/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _CONTEXT
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _CONTEXT {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _ContextFlagsOffset_;
	public static final int _DebugControlOffset_;
	public static final int _Dr0Offset_;
	public static final int _Dr1Offset_;
	public static final int _Dr2Offset_;
	public static final int _Dr3Offset_;
	public static final int _Dr6Offset_;
	public static final int _Dr7Offset_;
	public static final int _EFlagsOffset_;
	public static final int _FltSaveOffset_;
	public static final int _HeaderOffset_;
	public static final int _LastBranchFromRipOffset_;
	public static final int _LastBranchToRipOffset_;
	public static final int _LastExceptionFromRipOffset_;
	public static final int _LastExceptionToRipOffset_;
	public static final int _LegacyOffset_;
	public static final int _MxCsrOffset_;
	public static final int _P1HomeOffset_;
	public static final int _P2HomeOffset_;
	public static final int _P3HomeOffset_;
	public static final int _P4HomeOffset_;
	public static final int _P5HomeOffset_;
	public static final int _P6HomeOffset_;
	public static final int _R10Offset_;
	public static final int _R11Offset_;
	public static final int _R12Offset_;
	public static final int _R13Offset_;
	public static final int _R14Offset_;
	public static final int _R15Offset_;
	public static final int _R8Offset_;
	public static final int _R9Offset_;
	public static final int _RaxOffset_;
	public static final int _RbpOffset_;
	public static final int _RbxOffset_;
	public static final int _RcxOffset_;
	public static final int _RdiOffset_;
	public static final int _RdxOffset_;
	public static final int _RipOffset_;
	public static final int _RsiOffset_;
	public static final int _RspOffset_;
	public static final int _SegCsOffset_;
	public static final int _SegDsOffset_;
	public static final int _SegEsOffset_;
	public static final int _SegFsOffset_;
	public static final int _SegGsOffset_;
	public static final int _SegSsOffset_;
	public static final int _VectorControlOffset_;
	public static final int _VectorRegisterOffset_;
	public static final int _Xmm0Offset_;
	public static final int _Xmm1Offset_;
	public static final int _Xmm10Offset_;
	public static final int _Xmm11Offset_;
	public static final int _Xmm12Offset_;
	public static final int _Xmm13Offset_;
	public static final int _Xmm14Offset_;
	public static final int _Xmm15Offset_;
	public static final int _Xmm2Offset_;
	public static final int _Xmm3Offset_;
	public static final int _Xmm4Offset_;
	public static final int _Xmm5Offset_;
	public static final int _Xmm6Offset_;
	public static final int _Xmm7Offset_;
	public static final int _Xmm8Offset_;
	public static final int _Xmm9Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_ContextFlagsOffset_ = 0;
		_DebugControlOffset_ = 0;
		_Dr0Offset_ = 0;
		_Dr1Offset_ = 0;
		_Dr2Offset_ = 0;
		_Dr3Offset_ = 0;
		_Dr6Offset_ = 0;
		_Dr7Offset_ = 0;
		_EFlagsOffset_ = 0;
		_FltSaveOffset_ = 0;
		_HeaderOffset_ = 0;
		_LastBranchFromRipOffset_ = 0;
		_LastBranchToRipOffset_ = 0;
		_LastExceptionFromRipOffset_ = 0;
		_LastExceptionToRipOffset_ = 0;
		_LegacyOffset_ = 0;
		_MxCsrOffset_ = 0;
		_P1HomeOffset_ = 0;
		_P2HomeOffset_ = 0;
		_P3HomeOffset_ = 0;
		_P4HomeOffset_ = 0;
		_P5HomeOffset_ = 0;
		_P6HomeOffset_ = 0;
		_R10Offset_ = 0;
		_R11Offset_ = 0;
		_R12Offset_ = 0;
		_R13Offset_ = 0;
		_R14Offset_ = 0;
		_R15Offset_ = 0;
		_R8Offset_ = 0;
		_R9Offset_ = 0;
		_RaxOffset_ = 0;
		_RbpOffset_ = 0;
		_RbxOffset_ = 0;
		_RcxOffset_ = 0;
		_RdiOffset_ = 0;
		_RdxOffset_ = 0;
		_RipOffset_ = 0;
		_RsiOffset_ = 0;
		_RspOffset_ = 0;
		_SegCsOffset_ = 0;
		_SegDsOffset_ = 0;
		_SegEsOffset_ = 0;
		_SegFsOffset_ = 0;
		_SegGsOffset_ = 0;
		_SegSsOffset_ = 0;
		_VectorControlOffset_ = 0;
		_VectorRegisterOffset_ = 0;
		_Xmm0Offset_ = 0;
		_Xmm1Offset_ = 0;
		_Xmm10Offset_ = 0;
		_Xmm11Offset_ = 0;
		_Xmm12Offset_ = 0;
		_Xmm13Offset_ = 0;
		_Xmm14Offset_ = 0;
		_Xmm15Offset_ = 0;
		_Xmm2Offset_ = 0;
		_Xmm3Offset_ = 0;
		_Xmm4Offset_ = 0;
		_Xmm5Offset_ = 0;
		_Xmm6Offset_ = 0;
		_Xmm7Offset_ = 0;
		_Xmm8Offset_ = 0;
		_Xmm9Offset_ = 0;
	}

}
