/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _IMAGEHLP_MODULE64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _IMAGEHLP_MODULE64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _BaseOfImageOffset_;
	public static final int _CVDataOffset_;
	public static final int _CVSigOffset_;
	public static final int _CheckSumOffset_;
	public static final int _DbgUnmatchedOffset_;
	public static final int _GlobalSymbolsOffset_;
	public static final int _ImageNameOffset_;
	public static final int _ImageSizeOffset_;
	public static final int _LineNumbersOffset_;
	public static final int _LoadedImageNameOffset_;
	public static final int _LoadedPdbNameOffset_;
	public static final int _MachineTypeOffset_;
	public static final int _ModuleNameOffset_;
	public static final int _NumSymsOffset_;
	public static final int _PdbAgeOffset_;
	public static final int _PdbSigOffset_;
	public static final int _PdbSig70Offset_;
	public static final int _PdbUnmatchedOffset_;
	public static final int _PublicsOffset_;
	public static final int _ReservedOffset_;
	public static final int _SizeOfStructOffset_;
	public static final int _SourceIndexedOffset_;
	public static final int _SymTypeOffset_;
	public static final int _TimeDateStampOffset_;
	public static final int _TypeInfoOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_BaseOfImageOffset_ = 0;
		_CVDataOffset_ = 0;
		_CVSigOffset_ = 0;
		_CheckSumOffset_ = 0;
		_DbgUnmatchedOffset_ = 0;
		_GlobalSymbolsOffset_ = 0;
		_ImageNameOffset_ = 0;
		_ImageSizeOffset_ = 0;
		_LineNumbersOffset_ = 0;
		_LoadedImageNameOffset_ = 0;
		_LoadedPdbNameOffset_ = 0;
		_MachineTypeOffset_ = 0;
		_ModuleNameOffset_ = 0;
		_NumSymsOffset_ = 0;
		_PdbAgeOffset_ = 0;
		_PdbSigOffset_ = 0;
		_PdbSig70Offset_ = 0;
		_PdbUnmatchedOffset_ = 0;
		_PublicsOffset_ = 0;
		_ReservedOffset_ = 0;
		_SizeOfStructOffset_ = 0;
		_SourceIndexedOffset_ = 0;
		_SymTypeOffset_ = 0;
		_TimeDateStampOffset_ = 0;
		_TypeInfoOffset_ = 0;
	}

}
