/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: tagTYPEATTR
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class tagTYPEATTR {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _cFuncsOffset_;
	public static final int _cImplTypesOffset_;
	public static final int _cVarsOffset_;
	public static final int _cbAlignmentOffset_;
	public static final int _cbSizeInstanceOffset_;
	public static final int _cbSizeVftOffset_;
	public static final int _dwReservedOffset_;
	public static final int _guidOffset_;
	public static final int _idldescTypeOffset_;
	public static final int _lcidOffset_;
	public static final int _lpstrSchemaOffset_;
	public static final int _memidConstructorOffset_;
	public static final int _memidDestructorOffset_;
	public static final int _tdescAliasOffset_;
	public static final int _typekindOffset_;
	public static final int _wMajorVerNumOffset_;
	public static final int _wMinorVerNumOffset_;
	public static final int _wTypeFlagsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_cFuncsOffset_ = 0;
		_cImplTypesOffset_ = 0;
		_cVarsOffset_ = 0;
		_cbAlignmentOffset_ = 0;
		_cbSizeInstanceOffset_ = 0;
		_cbSizeVftOffset_ = 0;
		_dwReservedOffset_ = 0;
		_guidOffset_ = 0;
		_idldescTypeOffset_ = 0;
		_lcidOffset_ = 0;
		_lpstrSchemaOffset_ = 0;
		_memidConstructorOffset_ = 0;
		_memidDestructorOffset_ = 0;
		_tdescAliasOffset_ = 0;
		_typekindOffset_ = 0;
		_wMajorVerNumOffset_ = 0;
		_wMinorVerNumOffset_ = 0;
		_wTypeFlagsOffset_ = 0;
	}

}
