/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: tagVARIANT
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class tagVARIANT {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int ___OBSOLETE__VARIANT_BOOLOffset_;
	public static final int ___OBSOLETE__VARIANT_PBOOLOffset_;
	public static final int _bValOffset_;
	public static final int _boolValOffset_;
	public static final int _bstrValOffset_;
	public static final int _byrefOffset_;
	public static final int _cValOffset_;
	public static final int _cyValOffset_;
	public static final int _dateOffset_;
	public static final int _dblValOffset_;
	public static final int _decValOffset_;
	public static final int _fltValOffset_;
	public static final int _iValOffset_;
	public static final int _intValOffset_;
	public static final int _lValOffset_;
	public static final int _llValOffset_;
	public static final int _pRecInfoOffset_;
	public static final int _parrayOffset_;
	public static final int _pbValOffset_;
	public static final int _pboolValOffset_;
	public static final int _pbstrValOffset_;
	public static final int _pcValOffset_;
	public static final int _pcyValOffset_;
	public static final int _pdateOffset_;
	public static final int _pdblValOffset_;
	public static final int _pdecValOffset_;
	public static final int _pdispValOffset_;
	public static final int _pfltValOffset_;
	public static final int _piValOffset_;
	public static final int _pintValOffset_;
	public static final int _plValOffset_;
	public static final int _pllValOffset_;
	public static final int _pparrayOffset_;
	public static final int _ppdispValOffset_;
	public static final int _ppunkValOffset_;
	public static final int _pscodeOffset_;
	public static final int _puiValOffset_;
	public static final int _puintValOffset_;
	public static final int _pulValOffset_;
	public static final int _pullValOffset_;
	public static final int _punkValOffset_;
	public static final int _pvRecordOffset_;
	public static final int _pvarValOffset_;
	public static final int _scodeOffset_;
	public static final int _uiValOffset_;
	public static final int _uintValOffset_;
	public static final int _ulValOffset_;
	public static final int _ullValOffset_;
	public static final int _vtOffset_;
	public static final int _wReserved1Offset_;
	public static final int _wReserved2Offset_;
	public static final int _wReserved3Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		___OBSOLETE__VARIANT_BOOLOffset_ = 0;
		___OBSOLETE__VARIANT_PBOOLOffset_ = 0;
		_bValOffset_ = 0;
		_boolValOffset_ = 0;
		_bstrValOffset_ = 0;
		_byrefOffset_ = 0;
		_cValOffset_ = 0;
		_cyValOffset_ = 0;
		_dateOffset_ = 0;
		_dblValOffset_ = 0;
		_decValOffset_ = 0;
		_fltValOffset_ = 0;
		_iValOffset_ = 0;
		_intValOffset_ = 0;
		_lValOffset_ = 0;
		_llValOffset_ = 0;
		_pRecInfoOffset_ = 0;
		_parrayOffset_ = 0;
		_pbValOffset_ = 0;
		_pboolValOffset_ = 0;
		_pbstrValOffset_ = 0;
		_pcValOffset_ = 0;
		_pcyValOffset_ = 0;
		_pdateOffset_ = 0;
		_pdblValOffset_ = 0;
		_pdecValOffset_ = 0;
		_pdispValOffset_ = 0;
		_pfltValOffset_ = 0;
		_piValOffset_ = 0;
		_pintValOffset_ = 0;
		_plValOffset_ = 0;
		_pllValOffset_ = 0;
		_pparrayOffset_ = 0;
		_ppdispValOffset_ = 0;
		_ppunkValOffset_ = 0;
		_pscodeOffset_ = 0;
		_puiValOffset_ = 0;
		_puintValOffset_ = 0;
		_pulValOffset_ = 0;
		_pullValOffset_ = 0;
		_punkValOffset_ = 0;
		_pvRecordOffset_ = 0;
		_pvarValOffset_ = 0;
		_scodeOffset_ = 0;
		_uiValOffset_ = 0;
		_uintValOffset_ = 0;
		_ulValOffset_ = 0;
		_ullValOffset_ = 0;
		_vtOffset_ = 0;
		_wReserved1Offset_ = 0;
		_wReserved2Offset_ = 0;
		_wReserved3Offset_ = 0;
	}

}
