/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: EHExceptionRecordPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the EHExceptionRecordPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=EHExceptionRecord.class)
public class EHExceptionRecordPointer extends StructurePointer {

	// NULL
	public static final EHExceptionRecordPointer NULL = new EHExceptionRecordPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected EHExceptionRecordPointer(long address) {
		super(address);
	}

	public static EHExceptionRecordPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static EHExceptionRecordPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static EHExceptionRecordPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new EHExceptionRecordPointer(address);
	}

	public EHExceptionRecordPointer add(long count) {
		return EHExceptionRecordPointer.cast(address + (EHExceptionRecord.SIZEOF * count));
	}

	public EHExceptionRecordPointer add(Scalar count) {
		return add(count.longValue());
	}

	public EHExceptionRecordPointer addOffset(long offset) {
		return EHExceptionRecordPointer.cast(address + offset);
	}

	public EHExceptionRecordPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public EHExceptionRecordPointer sub(long count) {
		return EHExceptionRecordPointer.cast(address - (EHExceptionRecord.SIZEOF * count));
	}

	public EHExceptionRecordPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public EHExceptionRecordPointer subOffset(long offset) {
		return EHExceptionRecordPointer.cast(address - offset);
	}

	public EHExceptionRecordPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public EHExceptionRecordPointer untag(long mask) {
		return EHExceptionRecordPointer.cast(address & ~mask);
	}

	public EHExceptionRecordPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return EHExceptionRecord.SIZEOF;
	}

	// Implementation methods

	// void* ExceptionAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionAddressOffset_", declaredType="void*")
	public VoidPointer ExceptionAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(EHExceptionRecord._ExceptionAddressOffset_));
	}

	// void* ExceptionAddress
	public PointerPointer ExceptionAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(EHExceptionRecord._ExceptionAddressOffset_));
	}

	// U32 ExceptionCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionCodeOffset_", declaredType="U32")
	public UDATA ExceptionCode() throws CorruptDataException {
		return new U32(getIntAtOffset(EHExceptionRecord._ExceptionCodeOffset_));
	}

	// U32 ExceptionCode
	public UDATAPointer ExceptionCodeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(EHExceptionRecord._ExceptionCodeOffset_));
	}

	// U32 ExceptionFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionFlagsOffset_", declaredType="U32")
	public UDATA ExceptionFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(EHExceptionRecord._ExceptionFlagsOffset_));
	}

	// U32 ExceptionFlags
	public UDATAPointer ExceptionFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(EHExceptionRecord._ExceptionFlagsOffset_));
	}

	// _EXCEPTION_RECORD* ExceptionRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionRecordOffset_", declaredType="_EXCEPTION_RECORD*")
	public _EXCEPTION_RECORDPointer ExceptionRecord() throws CorruptDataException {
		return _EXCEPTION_RECORDPointer.cast(getPointerAtOffset(EHExceptionRecord._ExceptionRecordOffset_));
	}

	// _EXCEPTION_RECORD* ExceptionRecord
	public PointerPointer ExceptionRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(EHExceptionRecord._ExceptionRecordOffset_));
	}

	// U32 NumberParameters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberParametersOffset_", declaredType="U32")
	public UDATA NumberParameters() throws CorruptDataException {
		return new U32(getIntAtOffset(EHExceptionRecord._NumberParametersOffset_));
	}

	// U32 NumberParameters
	public UDATAPointer NumberParametersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(EHExceptionRecord._NumberParametersOffset_));
	}

	// EHExceptionRecord$EHParameters params
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_paramsOffset_", declaredType="EHExceptionRecord$EHParameters")
	public EHExceptionRecord$EHParametersPointer params() throws CorruptDataException {
		return EHExceptionRecord$EHParametersPointer.cast(nonNullFieldEA(EHExceptionRecord._paramsOffset_));
	}

	// EHExceptionRecord$EHParameters params
	public PointerPointer paramsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(EHExceptionRecord._paramsOffset_));
	}

}
