/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9HiddenInstanceFieldPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9HiddenInstanceFieldPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9HiddenInstanceField.class)
public class J9HiddenInstanceFieldPointer extends StructurePointer {

	// NULL
	public static final J9HiddenInstanceFieldPointer NULL = new J9HiddenInstanceFieldPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9HiddenInstanceFieldPointer(long address) {
		super(address);
	}

	public static J9HiddenInstanceFieldPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9HiddenInstanceFieldPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9HiddenInstanceFieldPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9HiddenInstanceFieldPointer(address);
	}

	public J9HiddenInstanceFieldPointer add(long count) {
		return J9HiddenInstanceFieldPointer.cast(address + (J9HiddenInstanceField.SIZEOF * count));
	}

	public J9HiddenInstanceFieldPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9HiddenInstanceFieldPointer addOffset(long offset) {
		return J9HiddenInstanceFieldPointer.cast(address + offset);
	}

	public J9HiddenInstanceFieldPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9HiddenInstanceFieldPointer sub(long count) {
		return J9HiddenInstanceFieldPointer.cast(address - (J9HiddenInstanceField.SIZEOF * count));
	}

	public J9HiddenInstanceFieldPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9HiddenInstanceFieldPointer subOffset(long offset) {
		return J9HiddenInstanceFieldPointer.cast(address - offset);
	}

	public J9HiddenInstanceFieldPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9HiddenInstanceFieldPointer untag(long mask) {
		return J9HiddenInstanceFieldPointer.cast(address & ~mask);
	}

	public J9HiddenInstanceFieldPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9HiddenInstanceField.SIZEOF;
	}

	// Implementation methods

	// J9UTF8* className
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classNameOffset_", declaredType="J9UTF8*")
	public J9UTF8Pointer className() throws CorruptDataException {
		return J9UTF8Pointer.cast(getPointerAtOffset(J9HiddenInstanceField._classNameOffset_));
	}

	// J9UTF8* className
	public PointerPointer classNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9HiddenInstanceField._classNameOffset_));
	}

	// U64 fieldOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fieldOffsetOffset_", declaredType="U64")
	public UDATA fieldOffset() throws CorruptDataException {
		return new U64(getLongAtOffset(J9HiddenInstanceField._fieldOffsetOffset_));
	}

	// U64 fieldOffset
	public UDATAPointer fieldOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9HiddenInstanceField._fieldOffsetOffset_));
	}

	// J9HiddenInstanceField* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="J9HiddenInstanceField*")
	public J9HiddenInstanceFieldPointer next() throws CorruptDataException {
		return J9HiddenInstanceFieldPointer.cast(getPointerAtOffset(J9HiddenInstanceField._nextOffset_));
	}

	// J9HiddenInstanceField* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9HiddenInstanceField._nextOffset_));
	}

	// U64* offsetReturnPtr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_offsetReturnPtrOffset_", declaredType="U64*")
	public UDATAPointer offsetReturnPtr() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(J9HiddenInstanceField._offsetReturnPtrOffset_));
	}

	// U64* offsetReturnPtr
	public PointerPointer offsetReturnPtrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9HiddenInstanceField._offsetReturnPtrOffset_));
	}

	// J9ROMFieldShape* shape
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shapeOffset_", declaredType="J9ROMFieldShape*")
	public J9ROMFieldShapePointer shape() throws CorruptDataException {
		return J9ROMFieldShapePointer.cast(getPointerAtOffset(J9HiddenInstanceField._shapeOffset_));
	}

	// J9ROMFieldShape* shape
	public PointerPointer shapeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9HiddenInstanceField._shapeOffset_));
	}

}
