/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9ProcessWin32PipesPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9ProcessWin32PipesPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9ProcessWin32Pipes.class)
public class J9ProcessWin32PipesPointer extends StructurePointer {

	// NULL
	public static final J9ProcessWin32PipesPointer NULL = new J9ProcessWin32PipesPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9ProcessWin32PipesPointer(long address) {
		super(address);
	}

	public static J9ProcessWin32PipesPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9ProcessWin32PipesPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9ProcessWin32PipesPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9ProcessWin32PipesPointer(address);
	}

	public J9ProcessWin32PipesPointer add(long count) {
		return J9ProcessWin32PipesPointer.cast(address + (J9ProcessWin32Pipes.SIZEOF * count));
	}

	public J9ProcessWin32PipesPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9ProcessWin32PipesPointer addOffset(long offset) {
		return J9ProcessWin32PipesPointer.cast(address + offset);
	}

	public J9ProcessWin32PipesPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9ProcessWin32PipesPointer sub(long count) {
		return J9ProcessWin32PipesPointer.cast(address - (J9ProcessWin32Pipes.SIZEOF * count));
	}

	public J9ProcessWin32PipesPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9ProcessWin32PipesPointer subOffset(long offset) {
		return J9ProcessWin32PipesPointer.cast(address - offset);
	}

	public J9ProcessWin32PipesPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9ProcessWin32PipesPointer untag(long mask) {
		return J9ProcessWin32PipesPointer.cast(address & ~mask);
	}

	public J9ProcessWin32PipesPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9ProcessWin32Pipes.SIZEOF;
	}

	// Implementation methods

	// void* errDup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errDupOffset_", declaredType="void*")
	public VoidPointer errDup() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._errDupOffset_));
	}

	// void* errDup
	public PointerPointer errDupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._errDupOffset_));
	}

	// void* errR
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errROffset_", declaredType="void*")
	public VoidPointer errR() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._errROffset_));
	}

	// void* errR
	public PointerPointer errREA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._errROffset_));
	}

	// void* errW
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errWOffset_", declaredType="void*")
	public VoidPointer errW() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._errWOffset_));
	}

	// void* errW
	public PointerPointer errWEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._errWOffset_));
	}

	// void* inDup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_inDupOffset_", declaredType="void*")
	public VoidPointer inDup() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._inDupOffset_));
	}

	// void* inDup
	public PointerPointer inDupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._inDupOffset_));
	}

	// void* inR
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_inROffset_", declaredType="void*")
	public VoidPointer inR() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._inROffset_));
	}

	// void* inR
	public PointerPointer inREA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._inROffset_));
	}

	// void* inW
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_inWOffset_", declaredType="void*")
	public VoidPointer inW() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._inWOffset_));
	}

	// void* inW
	public PointerPointer inWEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._inWOffset_));
	}

	// void* outDup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_outDupOffset_", declaredType="void*")
	public VoidPointer outDup() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._outDupOffset_));
	}

	// void* outDup
	public PointerPointer outDupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._outDupOffset_));
	}

	// void* outR
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_outROffset_", declaredType="void*")
	public VoidPointer outR() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._outROffset_));
	}

	// void* outR
	public PointerPointer outREA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._outROffset_));
	}

	// void* outW
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_outWOffset_", declaredType="void*")
	public VoidPointer outW() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9ProcessWin32Pipes._outWOffset_));
	}

	// void* outW
	public PointerPointer outWEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9ProcessWin32Pipes._outWOffset_));
	}

}
