/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: JDK1_1InitArgsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the JDK1_1InitArgsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=JDK1_1InitArgs.class)
public class JDK1_1InitArgsPointer extends StructurePointer {

	// NULL
	public static final JDK1_1InitArgsPointer NULL = new JDK1_1InitArgsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected JDK1_1InitArgsPointer(long address) {
		super(address);
	}

	public static JDK1_1InitArgsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static JDK1_1InitArgsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static JDK1_1InitArgsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new JDK1_1InitArgsPointer(address);
	}

	public JDK1_1InitArgsPointer add(long count) {
		return JDK1_1InitArgsPointer.cast(address + (JDK1_1InitArgs.SIZEOF * count));
	}

	public JDK1_1InitArgsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public JDK1_1InitArgsPointer addOffset(long offset) {
		return JDK1_1InitArgsPointer.cast(address + offset);
	}

	public JDK1_1InitArgsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public JDK1_1InitArgsPointer sub(long count) {
		return JDK1_1InitArgsPointer.cast(address - (JDK1_1InitArgs.SIZEOF * count));
	}

	public JDK1_1InitArgsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public JDK1_1InitArgsPointer subOffset(long offset) {
		return JDK1_1InitArgsPointer.cast(address - offset);
	}

	public JDK1_1InitArgsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public JDK1_1InitArgsPointer untag(long mask) {
		return JDK1_1InitArgsPointer.cast(address & ~mask);
	}

	public JDK1_1InitArgsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return JDK1_1InitArgs.SIZEOF;
	}

	// Implementation methods

	// void* abort
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_abortOffset_", declaredType="void*")
	public VoidPointer abort() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(JDK1_1InitArgs._abortOffset_));
	}

	// void* abort
	public PointerPointer abortEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JDK1_1InitArgs._abortOffset_));
	}

	// I32 checkSource
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_checkSourceOffset_", declaredType="I32")
	public IDATA checkSource() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._checkSourceOffset_));
	}

	// I32 checkSource
	public IDATAPointer checkSourceEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._checkSourceOffset_));
	}

	// const U8* classpath
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classpathOffset_", declaredType="const U8*")
	public U8Pointer classpath() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JDK1_1InitArgs._classpathOffset_));
	}

	// const U8* classpath
	public PointerPointer classpathEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JDK1_1InitArgs._classpathOffset_));
	}

	// I32 debugAgent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugAgentOffset_", declaredType="I32")
	public IDATA debugAgent() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._debugAgentOffset_));
	}

	// I32 debugAgent
	public IDATAPointer debugAgentEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._debugAgentOffset_));
	}

	// I32 debugPort
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugPortOffset_", declaredType="I32")
	public IDATA debugPort() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._debugPortOffset_));
	}

	// I32 debugPort
	public IDATAPointer debugPortEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._debugPortOffset_));
	}

	// I32 disableAsyncGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_disableAsyncGCOffset_", declaredType="I32")
	public IDATA disableAsyncGC() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._disableAsyncGCOffset_));
	}

	// I32 disableAsyncGC
	public IDATAPointer disableAsyncGCEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._disableAsyncGCOffset_));
	}

	// I32 enableClassGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_enableClassGCOffset_", declaredType="I32")
	public IDATA enableClassGC() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._enableClassGCOffset_));
	}

	// I32 enableClassGC
	public IDATAPointer enableClassGCEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._enableClassGCOffset_));
	}

	// I32 enableVerboseGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_enableVerboseGCOffset_", declaredType="I32")
	public IDATA enableVerboseGC() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._enableVerboseGCOffset_));
	}

	// I32 enableVerboseGC
	public IDATAPointer enableVerboseGCEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._enableVerboseGCOffset_));
	}

	// void* exit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exitOffset_", declaredType="void*")
	public VoidPointer exit() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(JDK1_1InitArgs._exitOffset_));
	}

	// void* exit
	public PointerPointer exitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JDK1_1InitArgs._exitOffset_));
	}

	// I32 javaStackSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_javaStackSizeOffset_", declaredType="I32")
	public IDATA javaStackSize() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._javaStackSizeOffset_));
	}

	// I32 javaStackSize
	public IDATAPointer javaStackSizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._javaStackSizeOffset_));
	}

	// I32 maxHeapSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxHeapSizeOffset_", declaredType="I32")
	public IDATA maxHeapSize() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._maxHeapSizeOffset_));
	}

	// I32 maxHeapSize
	public IDATAPointer maxHeapSizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._maxHeapSizeOffset_));
	}

	// I32 minHeapSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minHeapSizeOffset_", declaredType="I32")
	public IDATA minHeapSize() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._minHeapSizeOffset_));
	}

	// I32 minHeapSize
	public IDATAPointer minHeapSizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._minHeapSizeOffset_));
	}

	// I32 nativeStackSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nativeStackSizeOffset_", declaredType="I32")
	public IDATA nativeStackSize() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._nativeStackSizeOffset_));
	}

	// I32 nativeStackSize
	public IDATAPointer nativeStackSizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._nativeStackSizeOffset_));
	}

	// void** properties
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_propertiesOffset_", declaredType="void**")
	public PointerPointer properties() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(JDK1_1InitArgs._propertiesOffset_));
	}

	// void** properties
	public PointerPointer propertiesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JDK1_1InitArgs._propertiesOffset_));
	}

	// I32 verbose
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_verboseOffset_", declaredType="I32")
	public IDATA verbose() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._verboseOffset_));
	}

	// I32 verbose
	public IDATAPointer verboseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._verboseOffset_));
	}

	// I32 verifyMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_verifyModeOffset_", declaredType="I32")
	public IDATA verifyMode() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._verifyModeOffset_));
	}

	// I32 verifyMode
	public IDATAPointer verifyModeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._verifyModeOffset_));
	}

	// I32 version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="I32")
	public IDATA version() throws CorruptDataException {
		return new I32(getIntAtOffset(JDK1_1InitArgs._versionOffset_));
	}

	// I32 version
	public IDATAPointer versionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JDK1_1InitArgs._versionOffset_));
	}

	// void* vfprintf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vfprintfOffset_", declaredType="void*")
	public VoidPointer vfprintf() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(JDK1_1InitArgs._vfprintfOffset_));
	}

	// void* vfprintf
	public PointerPointer vfprintfEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JDK1_1InitArgs._vfprintfOffset_));
	}

}
