/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OMRWin32SignalInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OMRWin32SignalInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OMRWin32SignalInfo.class)
public class OMRWin32SignalInfoPointer extends StructurePointer {

	// NULL
	public static final OMRWin32SignalInfoPointer NULL = new OMRWin32SignalInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OMRWin32SignalInfoPointer(long address) {
		super(address);
	}

	public static OMRWin32SignalInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OMRWin32SignalInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OMRWin32SignalInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new OMRWin32SignalInfoPointer(address);
	}

	public OMRWin32SignalInfoPointer add(long count) {
		return OMRWin32SignalInfoPointer.cast(address + (OMRWin32SignalInfo.SIZEOF * count));
	}

	public OMRWin32SignalInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public OMRWin32SignalInfoPointer addOffset(long offset) {
		return OMRWin32SignalInfoPointer.cast(address + offset);
	}

	public OMRWin32SignalInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OMRWin32SignalInfoPointer sub(long count) {
		return OMRWin32SignalInfoPointer.cast(address - (OMRWin32SignalInfo.SIZEOF * count));
	}

	public OMRWin32SignalInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OMRWin32SignalInfoPointer subOffset(long offset) {
		return OMRWin32SignalInfoPointer.cast(address - offset);
	}

	public OMRWin32SignalInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OMRWin32SignalInfoPointer untag(long mask) {
		return OMRWin32SignalInfoPointer.cast(address & ~mask);
	}

	public OMRWin32SignalInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OMRWin32SignalInfo.SIZEOF;
	}

	// Implementation methods

	// _CONTEXT* ContextRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ContextRecordOffset_", declaredType="_CONTEXT*")
	public _CONTEXTPointer ContextRecord() throws CorruptDataException {
		return _CONTEXTPointer.cast(getPointerAtOffset(OMRWin32SignalInfo._ContextRecordOffset_));
	}

	// _CONTEXT* ContextRecord
	public PointerPointer ContextRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._ContextRecordOffset_));
	}

	// _EXCEPTION_RECORD* ExceptionRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionRecordOffset_", declaredType="_EXCEPTION_RECORD*")
	public _EXCEPTION_RECORDPointer ExceptionRecord() throws CorruptDataException {
		return _EXCEPTION_RECORDPointer.cast(getPointerAtOffset(OMRWin32SignalInfo._ExceptionRecordOffset_));
	}

	// _EXCEPTION_RECORD* ExceptionRecord
	public PointerPointer ExceptionRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._ExceptionRecordOffset_));
	}

	// U64 deferToTryExcept
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_deferToTryExceptOffset_", declaredType="U64")
	public UDATA deferToTryExcept() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRWin32SignalInfo._deferToTryExceptOffset_));
	}

	// U64 deferToTryExcept
	public UDATAPointer deferToTryExceptEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._deferToTryExceptOffset_));
	}

	// void* handlerAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_handlerAddressOffset_", declaredType="void*")
	public VoidPointer handlerAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRWin32SignalInfo._handlerAddressOffset_));
	}

	// void* handlerAddress
	public PointerPointer handlerAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._handlerAddressOffset_));
	}

	// void* handlerAddress2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_handlerAddress2Offset_", declaredType="void*")
	public VoidPointer handlerAddress2() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRWin32SignalInfo._handlerAddress2Offset_));
	}

	// void* handlerAddress2
	public PointerPointer handlerAddress2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._handlerAddress2Offset_));
	}

	// void* moduleBaseAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_moduleBaseAddressOffset_", declaredType="void*")
	public VoidPointer moduleBaseAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRWin32SignalInfo._moduleBaseAddressOffset_));
	}

	// void* moduleBaseAddress
	public PointerPointer moduleBaseAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._moduleBaseAddressOffset_));
	}

	// U8[] moduleName
	public U8Pointer moduleNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(OMRWin32SignalInfo._moduleNameOffset_));
	}

	// U64 offsetInDLL
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_offsetInDLLOffset_", declaredType="U64")
	public UDATA offsetInDLL() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRWin32SignalInfo._offsetInDLLOffset_));
	}

	// U64 offsetInDLL
	public UDATAPointer offsetInDLLEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._offsetInDLLOffset_));
	}

	// U32 portLibType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_portLibTypeOffset_", declaredType="U32")
	public UDATA portLibType() throws CorruptDataException {
		return new U32(getIntAtOffset(OMRWin32SignalInfo._portLibTypeOffset_));
	}

	// U32 portLibType
	public UDATAPointer portLibTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._portLibTypeOffset_));
	}

	// U32 systemType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_systemTypeOffset_", declaredType="U32")
	public UDATA systemType() throws CorruptDataException {
		return new U32(getIntAtOffset(OMRWin32SignalInfo._systemTypeOffset_));
	}

	// U32 systemType
	public UDATAPointer systemTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._systemTypeOffset_));
	}

	// U64 tryExceptHandlerIgnore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tryExceptHandlerIgnoreOffset_", declaredType="U64")
	public UDATA tryExceptHandlerIgnore() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRWin32SignalInfo._tryExceptHandlerIgnoreOffset_));
	}

	// U64 tryExceptHandlerIgnore
	public UDATAPointer tryExceptHandlerIgnoreEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRWin32SignalInfo._tryExceptHandlerIgnoreOffset_));
	}

}
