/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OMRWinAMD64AsyncHandlerRecordPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OMRWinAMD64AsyncHandlerRecordPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OMRWinAMD64AsyncHandlerRecord.class)
public class OMRWinAMD64AsyncHandlerRecordPointer extends StructurePointer {

	// NULL
	public static final OMRWinAMD64AsyncHandlerRecordPointer NULL = new OMRWinAMD64AsyncHandlerRecordPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OMRWinAMD64AsyncHandlerRecordPointer(long address) {
		super(address);
	}

	public static OMRWinAMD64AsyncHandlerRecordPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OMRWinAMD64AsyncHandlerRecordPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OMRWinAMD64AsyncHandlerRecordPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new OMRWinAMD64AsyncHandlerRecordPointer(address);
	}

	public OMRWinAMD64AsyncHandlerRecordPointer add(long count) {
		return OMRWinAMD64AsyncHandlerRecordPointer.cast(address + (OMRWinAMD64AsyncHandlerRecord.SIZEOF * count));
	}

	public OMRWinAMD64AsyncHandlerRecordPointer add(Scalar count) {
		return add(count.longValue());
	}

	public OMRWinAMD64AsyncHandlerRecordPointer addOffset(long offset) {
		return OMRWinAMD64AsyncHandlerRecordPointer.cast(address + offset);
	}

	public OMRWinAMD64AsyncHandlerRecordPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OMRWinAMD64AsyncHandlerRecordPointer sub(long count) {
		return OMRWinAMD64AsyncHandlerRecordPointer.cast(address - (OMRWinAMD64AsyncHandlerRecord.SIZEOF * count));
	}

	public OMRWinAMD64AsyncHandlerRecordPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OMRWinAMD64AsyncHandlerRecordPointer subOffset(long offset) {
		return OMRWinAMD64AsyncHandlerRecordPointer.cast(address - offset);
	}

	public OMRWinAMD64AsyncHandlerRecordPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OMRWinAMD64AsyncHandlerRecordPointer untag(long mask) {
		return OMRWinAMD64AsyncHandlerRecordPointer.cast(address & ~mask);
	}

	public OMRWinAMD64AsyncHandlerRecordPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OMRWinAMD64AsyncHandlerRecord.SIZEOF;
	}

	// Implementation methods

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(OMRWinAMD64AsyncHandlerRecord._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRWinAMD64AsyncHandlerRecord._flagsOffset_));
	}

	// void* handler
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_handlerOffset_", declaredType="void*")
	public VoidPointer handler() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRWinAMD64AsyncHandlerRecord._handlerOffset_));
	}

	// void* handler
	public PointerPointer handlerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWinAMD64AsyncHandlerRecord._handlerOffset_));
	}

	// void* handler_arg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_handler_argOffset_", declaredType="void*")
	public VoidPointer handler_arg() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRWinAMD64AsyncHandlerRecord._handler_argOffset_));
	}

	// void* handler_arg
	public PointerPointer handler_argEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWinAMD64AsyncHandlerRecord._handler_argOffset_));
	}

	// OMRWinAMD64AsyncHandlerRecord* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="OMRWinAMD64AsyncHandlerRecord*")
	public OMRWinAMD64AsyncHandlerRecordPointer next() throws CorruptDataException {
		return OMRWinAMD64AsyncHandlerRecordPointer.cast(getPointerAtOffset(OMRWinAMD64AsyncHandlerRecord._nextOffset_));
	}

	// OMRWinAMD64AsyncHandlerRecord* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWinAMD64AsyncHandlerRecord._nextOffset_));
	}

	// OMRPortLibrary* portLib
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_portLibOffset_", declaredType="OMRPortLibrary*")
	public OMRPortLibraryPointer portLib() throws CorruptDataException {
		return OMRPortLibraryPointer.cast(getPointerAtOffset(OMRWinAMD64AsyncHandlerRecord._portLibOffset_));
	}

	// OMRPortLibrary* portLib
	public PointerPointer portLibEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRWinAMD64AsyncHandlerRecord._portLibOffset_));
	}

}
