/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: RAMClassAllocationRequestPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the RAMClassAllocationRequestPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=RAMClassAllocationRequest.class)
public class RAMClassAllocationRequestPointer extends StructurePointer {

	// NULL
	public static final RAMClassAllocationRequestPointer NULL = new RAMClassAllocationRequestPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected RAMClassAllocationRequestPointer(long address) {
		super(address);
	}

	public static RAMClassAllocationRequestPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static RAMClassAllocationRequestPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static RAMClassAllocationRequestPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new RAMClassAllocationRequestPointer(address);
	}

	public RAMClassAllocationRequestPointer add(long count) {
		return RAMClassAllocationRequestPointer.cast(address + (RAMClassAllocationRequest.SIZEOF * count));
	}

	public RAMClassAllocationRequestPointer add(Scalar count) {
		return add(count.longValue());
	}

	public RAMClassAllocationRequestPointer addOffset(long offset) {
		return RAMClassAllocationRequestPointer.cast(address + offset);
	}

	public RAMClassAllocationRequestPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public RAMClassAllocationRequestPointer sub(long count) {
		return RAMClassAllocationRequestPointer.cast(address - (RAMClassAllocationRequest.SIZEOF * count));
	}

	public RAMClassAllocationRequestPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public RAMClassAllocationRequestPointer subOffset(long offset) {
		return RAMClassAllocationRequestPointer.cast(address - offset);
	}

	public RAMClassAllocationRequestPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public RAMClassAllocationRequestPointer untag(long mask) {
		return RAMClassAllocationRequestPointer.cast(address & ~mask);
	}

	public RAMClassAllocationRequestPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return RAMClassAllocationRequest.SIZEOF;
	}

	// Implementation methods

	// U64* address
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_addressOffset_", declaredType="U64*")
	public UDATAPointer address() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(RAMClassAllocationRequest._addressOffset_));
	}

	// U64* address
	public PointerPointer addressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._addressOffset_));
	}

	// U64 alignedSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_alignedSizeOffset_", declaredType="U64")
	public UDATA alignedSize() throws CorruptDataException {
		return new U64(getLongAtOffset(RAMClassAllocationRequest._alignedSizeOffset_));
	}

	// U64 alignedSize
	public UDATAPointer alignedSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._alignedSizeOffset_));
	}

	// U64 alignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_alignmentOffset_", declaredType="U64")
	public UDATA alignment() throws CorruptDataException {
		return new U64(getLongAtOffset(RAMClassAllocationRequest._alignmentOffset_));
	}

	// U64 alignment
	public UDATAPointer alignmentEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._alignmentOffset_));
	}

	// U64 fragmentSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fragmentSizeOffset_", declaredType="U64")
	public UDATA fragmentSize() throws CorruptDataException {
		return new U64(getLongAtOffset(RAMClassAllocationRequest._fragmentSizeOffset_));
	}

	// U64 fragmentSize
	public UDATAPointer fragmentSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._fragmentSizeOffset_));
	}

	// U64 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U64")
	public UDATA index() throws CorruptDataException {
		return new U64(getLongAtOffset(RAMClassAllocationRequest._indexOffset_));
	}

	// U64 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._indexOffset_));
	}

	// RAMClassAllocationRequest* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="RAMClassAllocationRequest*")
	public RAMClassAllocationRequestPointer next() throws CorruptDataException {
		return RAMClassAllocationRequestPointer.cast(getPointerAtOffset(RAMClassAllocationRequest._nextOffset_));
	}

	// RAMClassAllocationRequest* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._nextOffset_));
	}

	// U64 prefixSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prefixSizeOffset_", declaredType="U64")
	public UDATA prefixSize() throws CorruptDataException {
		return new U64(getLongAtOffset(RAMClassAllocationRequest._prefixSizeOffset_));
	}

	// U64 prefixSize
	public UDATAPointer prefixSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._prefixSizeOffset_));
	}

	// SegmentKind segmentKind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_segmentKindOffset_", declaredType="SegmentKind")
	public long segmentKind() throws CorruptDataException {
		if (SegmentKind.SIZEOF == 1) {
			return getByteAtOffset(RAMClassAllocationRequest._segmentKindOffset_);
		} else if (SegmentKind.SIZEOF == 2) {
			return getShortAtOffset(RAMClassAllocationRequest._segmentKindOffset_);
		} else if (SegmentKind.SIZEOF == 4) {
			return getIntAtOffset(RAMClassAllocationRequest._segmentKindOffset_);
		} else if (SegmentKind.SIZEOF == 8) {
			return getLongAtOffset(RAMClassAllocationRequest._segmentKindOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// SegmentKind segmentKind
	public EnumPointer segmentKindEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(RAMClassAllocationRequest._segmentKindOffset_), SegmentKind.class);
	}

}
