/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ROMClassBuilder$SizeInformationPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ROMClassBuilder$SizeInformationPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ROMClassBuilder$SizeInformation.class)
public class ROMClassBuilder$SizeInformationPointer extends StructurePointer {

	// NULL
	public static final ROMClassBuilder$SizeInformationPointer NULL = new ROMClassBuilder$SizeInformationPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ROMClassBuilder$SizeInformationPointer(long address) {
		super(address);
	}

	public static ROMClassBuilder$SizeInformationPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ROMClassBuilder$SizeInformationPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ROMClassBuilder$SizeInformationPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ROMClassBuilder$SizeInformationPointer(address);
	}

	public ROMClassBuilder$SizeInformationPointer add(long count) {
		return ROMClassBuilder$SizeInformationPointer.cast(address + (ROMClassBuilder$SizeInformation.SIZEOF * count));
	}

	public ROMClassBuilder$SizeInformationPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ROMClassBuilder$SizeInformationPointer addOffset(long offset) {
		return ROMClassBuilder$SizeInformationPointer.cast(address + offset);
	}

	public ROMClassBuilder$SizeInformationPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ROMClassBuilder$SizeInformationPointer sub(long count) {
		return ROMClassBuilder$SizeInformationPointer.cast(address - (ROMClassBuilder$SizeInformation.SIZEOF * count));
	}

	public ROMClassBuilder$SizeInformationPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ROMClassBuilder$SizeInformationPointer subOffset(long offset) {
		return ROMClassBuilder$SizeInformationPointer.cast(address - offset);
	}

	public ROMClassBuilder$SizeInformationPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ROMClassBuilder$SizeInformationPointer untag(long mask) {
		return ROMClassBuilder$SizeInformationPointer.cast(address & ~mask);
	}

	public ROMClassBuilder$SizeInformationPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ROMClassBuilder$SizeInformation.SIZEOF;
	}

	// Implementation methods

	// U64 lineNumberSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lineNumberSizeOffset_", declaredType="U64")
	public UDATA lineNumberSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ROMClassBuilder$SizeInformation._lineNumberSizeOffset_));
	}

	// U64 lineNumberSize
	public UDATAPointer lineNumberSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ROMClassBuilder$SizeInformation._lineNumberSizeOffset_));
	}

	// U64 rawClassDataSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rawClassDataSizeOffset_", declaredType="U64")
	public UDATA rawClassDataSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ROMClassBuilder$SizeInformation._rawClassDataSizeOffset_));
	}

	// U64 rawClassDataSize
	public UDATAPointer rawClassDataSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ROMClassBuilder$SizeInformation._rawClassDataSizeOffset_));
	}

	// U64 rcWithOutUTF8sSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rcWithOutUTF8sSizeOffset_", declaredType="U64")
	public UDATA rcWithOutUTF8sSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ROMClassBuilder$SizeInformation._rcWithOutUTF8sSizeOffset_));
	}

	// U64 rcWithOutUTF8sSize
	public UDATAPointer rcWithOutUTF8sSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ROMClassBuilder$SizeInformation._rcWithOutUTF8sSizeOffset_));
	}

	// U64 utf8sSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_utf8sSizeOffset_", declaredType="U64")
	public UDATA utf8sSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ROMClassBuilder$SizeInformation._utf8sSizeOffset_));
	}

	// U64 utf8sSize
	public UDATAPointer utf8sSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ROMClassBuilder$SizeInformation._utf8sSizeOffset_));
	}

	// U64 variableInfoSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_variableInfoSizeOffset_", declaredType="U64")
	public UDATA variableInfoSize() throws CorruptDataException {
		return new U64(getLongAtOffset(ROMClassBuilder$SizeInformation._variableInfoSizeOffset_));
	}

	// U64 variableInfoSize
	public UDATAPointer variableInfoSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ROMClassBuilder$SizeInformation._variableInfoSizeOffset_));
	}

}
