/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _CONTEXTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _CONTEXTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_CONTEXT.class)
public class _CONTEXTPointer extends StructurePointer {

	// NULL
	public static final _CONTEXTPointer NULL = new _CONTEXTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _CONTEXTPointer(long address) {
		super(address);
	}

	public static _CONTEXTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _CONTEXTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _CONTEXTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _CONTEXTPointer(address);
	}

	public _CONTEXTPointer add(long count) {
		return _CONTEXTPointer.cast(address + (_CONTEXT.SIZEOF * count));
	}

	public _CONTEXTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _CONTEXTPointer addOffset(long offset) {
		return _CONTEXTPointer.cast(address + offset);
	}

	public _CONTEXTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _CONTEXTPointer sub(long count) {
		return _CONTEXTPointer.cast(address - (_CONTEXT.SIZEOF * count));
	}

	public _CONTEXTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _CONTEXTPointer subOffset(long offset) {
		return _CONTEXTPointer.cast(address - offset);
	}

	public _CONTEXTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _CONTEXTPointer untag(long mask) {
		return _CONTEXTPointer.cast(address & ~mask);
	}

	public _CONTEXTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _CONTEXT.SIZEOF;
	}

	// Implementation methods

	// U32 ContextFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ContextFlagsOffset_", declaredType="U32")
	public UDATA ContextFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_CONTEXT._ContextFlagsOffset_));
	}

	// U32 ContextFlags
	public UDATAPointer ContextFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._ContextFlagsOffset_));
	}

	// U64 DebugControl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DebugControlOffset_", declaredType="U64")
	public UDATA DebugControl() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._DebugControlOffset_));
	}

	// U64 DebugControl
	public UDATAPointer DebugControlEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._DebugControlOffset_));
	}

	// U64 Dr0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Dr0Offset_", declaredType="U64")
	public UDATA Dr0() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._Dr0Offset_));
	}

	// U64 Dr0
	public UDATAPointer Dr0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._Dr0Offset_));
	}

	// U64 Dr1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Dr1Offset_", declaredType="U64")
	public UDATA Dr1() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._Dr1Offset_));
	}

	// U64 Dr1
	public UDATAPointer Dr1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._Dr1Offset_));
	}

	// U64 Dr2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Dr2Offset_", declaredType="U64")
	public UDATA Dr2() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._Dr2Offset_));
	}

	// U64 Dr2
	public UDATAPointer Dr2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._Dr2Offset_));
	}

	// U64 Dr3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Dr3Offset_", declaredType="U64")
	public UDATA Dr3() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._Dr3Offset_));
	}

	// U64 Dr3
	public UDATAPointer Dr3EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._Dr3Offset_));
	}

	// U64 Dr6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Dr6Offset_", declaredType="U64")
	public UDATA Dr6() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._Dr6Offset_));
	}

	// U64 Dr6
	public UDATAPointer Dr6EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._Dr6Offset_));
	}

	// U64 Dr7
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Dr7Offset_", declaredType="U64")
	public UDATA Dr7() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._Dr7Offset_));
	}

	// U64 Dr7
	public UDATAPointer Dr7EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._Dr7Offset_));
	}

	// U32 EFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EFlagsOffset_", declaredType="U32")
	public UDATA EFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_CONTEXT._EFlagsOffset_));
	}

	// U32 EFlags
	public UDATAPointer EFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._EFlagsOffset_));
	}

	// _XSAVE_FORMAT FltSave
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FltSaveOffset_", declaredType="_XSAVE_FORMAT")
	public _XSAVE_FORMATPointer FltSave() throws CorruptDataException {
		return _XSAVE_FORMATPointer.cast(nonNullFieldEA(_CONTEXT._FltSaveOffset_));
	}

	// _XSAVE_FORMAT FltSave
	public PointerPointer FltSaveEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._FltSaveOffset_));
	}

	// _M128A[] Header
	public _M128APointer HeaderEA() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._HeaderOffset_));
	}

	// U64 LastBranchFromRip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LastBranchFromRipOffset_", declaredType="U64")
	public UDATA LastBranchFromRip() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._LastBranchFromRipOffset_));
	}

	// U64 LastBranchFromRip
	public UDATAPointer LastBranchFromRipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._LastBranchFromRipOffset_));
	}

	// U64 LastBranchToRip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LastBranchToRipOffset_", declaredType="U64")
	public UDATA LastBranchToRip() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._LastBranchToRipOffset_));
	}

	// U64 LastBranchToRip
	public UDATAPointer LastBranchToRipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._LastBranchToRipOffset_));
	}

	// U64 LastExceptionFromRip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LastExceptionFromRipOffset_", declaredType="U64")
	public UDATA LastExceptionFromRip() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._LastExceptionFromRipOffset_));
	}

	// U64 LastExceptionFromRip
	public UDATAPointer LastExceptionFromRipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._LastExceptionFromRipOffset_));
	}

	// U64 LastExceptionToRip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LastExceptionToRipOffset_", declaredType="U64")
	public UDATA LastExceptionToRip() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._LastExceptionToRipOffset_));
	}

	// U64 LastExceptionToRip
	public UDATAPointer LastExceptionToRipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._LastExceptionToRipOffset_));
	}

	// _M128A[] Legacy
	public _M128APointer LegacyEA() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._LegacyOffset_));
	}

	// U32 MxCsr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MxCsrOffset_", declaredType="U32")
	public UDATA MxCsr() throws CorruptDataException {
		return new U32(getIntAtOffset(_CONTEXT._MxCsrOffset_));
	}

	// U32 MxCsr
	public UDATAPointer MxCsrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._MxCsrOffset_));
	}

	// U64 P1Home
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_P1HomeOffset_", declaredType="U64")
	public UDATA P1Home() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._P1HomeOffset_));
	}

	// U64 P1Home
	public UDATAPointer P1HomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._P1HomeOffset_));
	}

	// U64 P2Home
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_P2HomeOffset_", declaredType="U64")
	public UDATA P2Home() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._P2HomeOffset_));
	}

	// U64 P2Home
	public UDATAPointer P2HomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._P2HomeOffset_));
	}

	// U64 P3Home
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_P3HomeOffset_", declaredType="U64")
	public UDATA P3Home() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._P3HomeOffset_));
	}

	// U64 P3Home
	public UDATAPointer P3HomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._P3HomeOffset_));
	}

	// U64 P4Home
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_P4HomeOffset_", declaredType="U64")
	public UDATA P4Home() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._P4HomeOffset_));
	}

	// U64 P4Home
	public UDATAPointer P4HomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._P4HomeOffset_));
	}

	// U64 P5Home
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_P5HomeOffset_", declaredType="U64")
	public UDATA P5Home() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._P5HomeOffset_));
	}

	// U64 P5Home
	public UDATAPointer P5HomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._P5HomeOffset_));
	}

	// U64 P6Home
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_P6HomeOffset_", declaredType="U64")
	public UDATA P6Home() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._P6HomeOffset_));
	}

	// U64 P6Home
	public UDATAPointer P6HomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._P6HomeOffset_));
	}

	// U64 R10
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R10Offset_", declaredType="U64")
	public UDATA R10() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R10Offset_));
	}

	// U64 R10
	public UDATAPointer R10EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R10Offset_));
	}

	// U64 R11
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R11Offset_", declaredType="U64")
	public UDATA R11() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R11Offset_));
	}

	// U64 R11
	public UDATAPointer R11EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R11Offset_));
	}

	// U64 R12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R12Offset_", declaredType="U64")
	public UDATA R12() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R12Offset_));
	}

	// U64 R12
	public UDATAPointer R12EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R12Offset_));
	}

	// U64 R13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R13Offset_", declaredType="U64")
	public UDATA R13() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R13Offset_));
	}

	// U64 R13
	public UDATAPointer R13EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R13Offset_));
	}

	// U64 R14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R14Offset_", declaredType="U64")
	public UDATA R14() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R14Offset_));
	}

	// U64 R14
	public UDATAPointer R14EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R14Offset_));
	}

	// U64 R15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R15Offset_", declaredType="U64")
	public UDATA R15() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R15Offset_));
	}

	// U64 R15
	public UDATAPointer R15EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R15Offset_));
	}

	// U64 R8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R8Offset_", declaredType="U64")
	public UDATA R8() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R8Offset_));
	}

	// U64 R8
	public UDATAPointer R8EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R8Offset_));
	}

	// U64 R9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_R9Offset_", declaredType="U64")
	public UDATA R9() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._R9Offset_));
	}

	// U64 R9
	public UDATAPointer R9EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._R9Offset_));
	}

	// U64 Rax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RaxOffset_", declaredType="U64")
	public UDATA Rax() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RaxOffset_));
	}

	// U64 Rax
	public UDATAPointer RaxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RaxOffset_));
	}

	// U64 Rbp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RbpOffset_", declaredType="U64")
	public UDATA Rbp() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RbpOffset_));
	}

	// U64 Rbp
	public UDATAPointer RbpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RbpOffset_));
	}

	// U64 Rbx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RbxOffset_", declaredType="U64")
	public UDATA Rbx() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RbxOffset_));
	}

	// U64 Rbx
	public UDATAPointer RbxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RbxOffset_));
	}

	// U64 Rcx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RcxOffset_", declaredType="U64")
	public UDATA Rcx() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RcxOffset_));
	}

	// U64 Rcx
	public UDATAPointer RcxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RcxOffset_));
	}

	// U64 Rdi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RdiOffset_", declaredType="U64")
	public UDATA Rdi() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RdiOffset_));
	}

	// U64 Rdi
	public UDATAPointer RdiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RdiOffset_));
	}

	// U64 Rdx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RdxOffset_", declaredType="U64")
	public UDATA Rdx() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RdxOffset_));
	}

	// U64 Rdx
	public UDATAPointer RdxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RdxOffset_));
	}

	// U64 Rip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RipOffset_", declaredType="U64")
	public UDATA Rip() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RipOffset_));
	}

	// U64 Rip
	public UDATAPointer RipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RipOffset_));
	}

	// U64 Rsi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RsiOffset_", declaredType="U64")
	public UDATA Rsi() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RsiOffset_));
	}

	// U64 Rsi
	public UDATAPointer RsiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RsiOffset_));
	}

	// U64 Rsp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RspOffset_", declaredType="U64")
	public UDATA Rsp() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._RspOffset_));
	}

	// U64 Rsp
	public UDATAPointer RspEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._RspOffset_));
	}

	// U16 SegCs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SegCsOffset_", declaredType="U16")
	public U16 SegCs() throws CorruptDataException {
		return new U16(getShortAtOffset(_CONTEXT._SegCsOffset_));
	}

	// U16 SegCs
	public U16Pointer SegCsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_CONTEXT._SegCsOffset_));
	}

	// U16 SegDs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SegDsOffset_", declaredType="U16")
	public U16 SegDs() throws CorruptDataException {
		return new U16(getShortAtOffset(_CONTEXT._SegDsOffset_));
	}

	// U16 SegDs
	public U16Pointer SegDsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_CONTEXT._SegDsOffset_));
	}

	// U16 SegEs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SegEsOffset_", declaredType="U16")
	public U16 SegEs() throws CorruptDataException {
		return new U16(getShortAtOffset(_CONTEXT._SegEsOffset_));
	}

	// U16 SegEs
	public U16Pointer SegEsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_CONTEXT._SegEsOffset_));
	}

	// U16 SegFs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SegFsOffset_", declaredType="U16")
	public U16 SegFs() throws CorruptDataException {
		return new U16(getShortAtOffset(_CONTEXT._SegFsOffset_));
	}

	// U16 SegFs
	public U16Pointer SegFsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_CONTEXT._SegFsOffset_));
	}

	// U16 SegGs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SegGsOffset_", declaredType="U16")
	public U16 SegGs() throws CorruptDataException {
		return new U16(getShortAtOffset(_CONTEXT._SegGsOffset_));
	}

	// U16 SegGs
	public U16Pointer SegGsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_CONTEXT._SegGsOffset_));
	}

	// U16 SegSs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SegSsOffset_", declaredType="U16")
	public U16 SegSs() throws CorruptDataException {
		return new U16(getShortAtOffset(_CONTEXT._SegSsOffset_));
	}

	// U16 SegSs
	public U16Pointer SegSsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_CONTEXT._SegSsOffset_));
	}

	// U64 VectorControl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VectorControlOffset_", declaredType="U64")
	public UDATA VectorControl() throws CorruptDataException {
		return new U64(getLongAtOffset(_CONTEXT._VectorControlOffset_));
	}

	// U64 VectorControl
	public UDATAPointer VectorControlEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_CONTEXT._VectorControlOffset_));
	}

	// _M128A[] VectorRegister
	public _M128APointer VectorRegisterEA() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._VectorRegisterOffset_));
	}

	// _M128A Xmm0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm0Offset_", declaredType="_M128A")
	public _M128APointer Xmm0() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm0Offset_));
	}

	// _M128A Xmm0
	public PointerPointer Xmm0EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm0Offset_));
	}

	// _M128A Xmm1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm1Offset_", declaredType="_M128A")
	public _M128APointer Xmm1() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm1Offset_));
	}

	// _M128A Xmm1
	public PointerPointer Xmm1EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm1Offset_));
	}

	// _M128A Xmm10
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm10Offset_", declaredType="_M128A")
	public _M128APointer Xmm10() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm10Offset_));
	}

	// _M128A Xmm10
	public PointerPointer Xmm10EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm10Offset_));
	}

	// _M128A Xmm11
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm11Offset_", declaredType="_M128A")
	public _M128APointer Xmm11() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm11Offset_));
	}

	// _M128A Xmm11
	public PointerPointer Xmm11EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm11Offset_));
	}

	// _M128A Xmm12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm12Offset_", declaredType="_M128A")
	public _M128APointer Xmm12() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm12Offset_));
	}

	// _M128A Xmm12
	public PointerPointer Xmm12EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm12Offset_));
	}

	// _M128A Xmm13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm13Offset_", declaredType="_M128A")
	public _M128APointer Xmm13() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm13Offset_));
	}

	// _M128A Xmm13
	public PointerPointer Xmm13EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm13Offset_));
	}

	// _M128A Xmm14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm14Offset_", declaredType="_M128A")
	public _M128APointer Xmm14() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm14Offset_));
	}

	// _M128A Xmm14
	public PointerPointer Xmm14EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm14Offset_));
	}

	// _M128A Xmm15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm15Offset_", declaredType="_M128A")
	public _M128APointer Xmm15() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm15Offset_));
	}

	// _M128A Xmm15
	public PointerPointer Xmm15EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm15Offset_));
	}

	// _M128A Xmm2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm2Offset_", declaredType="_M128A")
	public _M128APointer Xmm2() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm2Offset_));
	}

	// _M128A Xmm2
	public PointerPointer Xmm2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm2Offset_));
	}

	// _M128A Xmm3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm3Offset_", declaredType="_M128A")
	public _M128APointer Xmm3() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm3Offset_));
	}

	// _M128A Xmm3
	public PointerPointer Xmm3EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm3Offset_));
	}

	// _M128A Xmm4
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm4Offset_", declaredType="_M128A")
	public _M128APointer Xmm4() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm4Offset_));
	}

	// _M128A Xmm4
	public PointerPointer Xmm4EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm4Offset_));
	}

	// _M128A Xmm5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm5Offset_", declaredType="_M128A")
	public _M128APointer Xmm5() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm5Offset_));
	}

	// _M128A Xmm5
	public PointerPointer Xmm5EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm5Offset_));
	}

	// _M128A Xmm6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm6Offset_", declaredType="_M128A")
	public _M128APointer Xmm6() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm6Offset_));
	}

	// _M128A Xmm6
	public PointerPointer Xmm6EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm6Offset_));
	}

	// _M128A Xmm7
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm7Offset_", declaredType="_M128A")
	public _M128APointer Xmm7() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm7Offset_));
	}

	// _M128A Xmm7
	public PointerPointer Xmm7EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm7Offset_));
	}

	// _M128A Xmm8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm8Offset_", declaredType="_M128A")
	public _M128APointer Xmm8() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm8Offset_));
	}

	// _M128A Xmm8
	public PointerPointer Xmm8EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm8Offset_));
	}

	// _M128A Xmm9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Xmm9Offset_", declaredType="_M128A")
	public _M128APointer Xmm9() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_CONTEXT._Xmm9Offset_));
	}

	// _M128A Xmm9
	public PointerPointer Xmm9EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_CONTEXT._Xmm9Offset_));
	}

}
