/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _COORDPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _COORDPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_COORD.class)
public class _COORDPointer extends StructurePointer {

	// NULL
	public static final _COORDPointer NULL = new _COORDPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _COORDPointer(long address) {
		super(address);
	}

	public static _COORDPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _COORDPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _COORDPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _COORDPointer(address);
	}

	public _COORDPointer add(long count) {
		return _COORDPointer.cast(address + (_COORD.SIZEOF * count));
	}

	public _COORDPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _COORDPointer addOffset(long offset) {
		return _COORDPointer.cast(address + offset);
	}

	public _COORDPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _COORDPointer sub(long count) {
		return _COORDPointer.cast(address - (_COORD.SIZEOF * count));
	}

	public _COORDPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _COORDPointer subOffset(long offset) {
		return _COORDPointer.cast(address - offset);
	}

	public _COORDPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _COORDPointer untag(long mask) {
		return _COORDPointer.cast(address & ~mask);
	}

	public _COORDPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _COORD.SIZEOF;
	}

	// Implementation methods

	// I16 X
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_XOffset_", declaredType="I16")
	public I16 X() throws CorruptDataException {
		return new I16(getShortAtOffset(_COORD._XOffset_));
	}

	// I16 X
	public I16Pointer XEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_COORD._XOffset_));
	}

	// I16 Y
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_YOffset_", declaredType="I16")
	public I16 Y() throws CorruptDataException {
		return new I16(getShortAtOffset(_COORD._YOffset_));
	}

	// I16 Y
	public I16Pointer YEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_COORD._YOffset_));
	}

}
