/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _DISPATCHER_CONTEXTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _DISPATCHER_CONTEXTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_DISPATCHER_CONTEXT.class)
public class _DISPATCHER_CONTEXTPointer extends StructurePointer {

	// NULL
	public static final _DISPATCHER_CONTEXTPointer NULL = new _DISPATCHER_CONTEXTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _DISPATCHER_CONTEXTPointer(long address) {
		super(address);
	}

	public static _DISPATCHER_CONTEXTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _DISPATCHER_CONTEXTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _DISPATCHER_CONTEXTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _DISPATCHER_CONTEXTPointer(address);
	}

	public _DISPATCHER_CONTEXTPointer add(long count) {
		return _DISPATCHER_CONTEXTPointer.cast(address + (_DISPATCHER_CONTEXT.SIZEOF * count));
	}

	public _DISPATCHER_CONTEXTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _DISPATCHER_CONTEXTPointer addOffset(long offset) {
		return _DISPATCHER_CONTEXTPointer.cast(address + offset);
	}

	public _DISPATCHER_CONTEXTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _DISPATCHER_CONTEXTPointer sub(long count) {
		return _DISPATCHER_CONTEXTPointer.cast(address - (_DISPATCHER_CONTEXT.SIZEOF * count));
	}

	public _DISPATCHER_CONTEXTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _DISPATCHER_CONTEXTPointer subOffset(long offset) {
		return _DISPATCHER_CONTEXTPointer.cast(address - offset);
	}

	public _DISPATCHER_CONTEXTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _DISPATCHER_CONTEXTPointer untag(long mask) {
		return _DISPATCHER_CONTEXTPointer.cast(address & ~mask);
	}

	public _DISPATCHER_CONTEXTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _DISPATCHER_CONTEXT.SIZEOF;
	}

	// Implementation methods

	// _CONTEXT* ContextRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ContextRecordOffset_", declaredType="_CONTEXT*")
	public _CONTEXTPointer ContextRecord() throws CorruptDataException {
		return _CONTEXTPointer.cast(getPointerAtOffset(_DISPATCHER_CONTEXT._ContextRecordOffset_));
	}

	// _CONTEXT* ContextRecord
	public PointerPointer ContextRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._ContextRecordOffset_));
	}

	// U64 ControlPc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ControlPcOffset_", declaredType="U64")
	public UDATA ControlPc() throws CorruptDataException {
		return new U64(getLongAtOffset(_DISPATCHER_CONTEXT._ControlPcOffset_));
	}

	// U64 ControlPc
	public UDATAPointer ControlPcEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._ControlPcOffset_));
	}

	// U64 EstablisherFrame
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EstablisherFrameOffset_", declaredType="U64")
	public UDATA EstablisherFrame() throws CorruptDataException {
		return new U64(getLongAtOffset(_DISPATCHER_CONTEXT._EstablisherFrameOffset_));
	}

	// U64 EstablisherFrame
	public UDATAPointer EstablisherFrameEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._EstablisherFrameOffset_));
	}

	// U32 Fill0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Fill0Offset_", declaredType="U32")
	public UDATA Fill0() throws CorruptDataException {
		return new U32(getIntAtOffset(_DISPATCHER_CONTEXT._Fill0Offset_));
	}

	// U32 Fill0
	public UDATAPointer Fill0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._Fill0Offset_));
	}

	// _IMAGE_RUNTIME_FUNCTION_ENTRY* FunctionEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FunctionEntryOffset_", declaredType="_IMAGE_RUNTIME_FUNCTION_ENTRY*")
	public _IMAGE_RUNTIME_FUNCTION_ENTRYPointer FunctionEntry() throws CorruptDataException {
		return _IMAGE_RUNTIME_FUNCTION_ENTRYPointer.cast(getPointerAtOffset(_DISPATCHER_CONTEXT._FunctionEntryOffset_));
	}

	// _IMAGE_RUNTIME_FUNCTION_ENTRY* FunctionEntry
	public PointerPointer FunctionEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._FunctionEntryOffset_));
	}

	// void* HandlerData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_HandlerDataOffset_", declaredType="void*")
	public VoidPointer HandlerData() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_DISPATCHER_CONTEXT._HandlerDataOffset_));
	}

	// void* HandlerData
	public PointerPointer HandlerDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._HandlerDataOffset_));
	}

	// _UNWIND_HISTORY_TABLE* HistoryTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_HistoryTableOffset_", declaredType="_UNWIND_HISTORY_TABLE*")
	public _UNWIND_HISTORY_TABLEPointer HistoryTable() throws CorruptDataException {
		return _UNWIND_HISTORY_TABLEPointer.cast(getPointerAtOffset(_DISPATCHER_CONTEXT._HistoryTableOffset_));
	}

	// _UNWIND_HISTORY_TABLE* HistoryTable
	public PointerPointer HistoryTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._HistoryTableOffset_));
	}

	// U64 ImageBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ImageBaseOffset_", declaredType="U64")
	public UDATA ImageBase() throws CorruptDataException {
		return new U64(getLongAtOffset(_DISPATCHER_CONTEXT._ImageBaseOffset_));
	}

	// U64 ImageBase
	public UDATAPointer ImageBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._ImageBaseOffset_));
	}

	// void* LanguageHandler
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LanguageHandlerOffset_", declaredType="void*")
	public VoidPointer LanguageHandler() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_DISPATCHER_CONTEXT._LanguageHandlerOffset_));
	}

	// void* LanguageHandler
	public PointerPointer LanguageHandlerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._LanguageHandlerOffset_));
	}

	// U32 ScopeIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ScopeIndexOffset_", declaredType="U32")
	public UDATA ScopeIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(_DISPATCHER_CONTEXT._ScopeIndexOffset_));
	}

	// U32 ScopeIndex
	public UDATAPointer ScopeIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._ScopeIndexOffset_));
	}

	// U64 TargetIp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TargetIpOffset_", declaredType="U64")
	public UDATA TargetIp() throws CorruptDataException {
		return new U64(getLongAtOffset(_DISPATCHER_CONTEXT._TargetIpOffset_));
	}

	// U64 TargetIp
	public UDATAPointer TargetIpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DISPATCHER_CONTEXT._TargetIpOffset_));
	}

}
