/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _EVENT_DATA_DESCRIPTORPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _EVENT_DATA_DESCRIPTORPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_EVENT_DATA_DESCRIPTOR.class)
public class _EVENT_DATA_DESCRIPTORPointer extends StructurePointer {

	// NULL
	public static final _EVENT_DATA_DESCRIPTORPointer NULL = new _EVENT_DATA_DESCRIPTORPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _EVENT_DATA_DESCRIPTORPointer(long address) {
		super(address);
	}

	public static _EVENT_DATA_DESCRIPTORPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _EVENT_DATA_DESCRIPTORPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _EVENT_DATA_DESCRIPTORPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _EVENT_DATA_DESCRIPTORPointer(address);
	}

	public _EVENT_DATA_DESCRIPTORPointer add(long count) {
		return _EVENT_DATA_DESCRIPTORPointer.cast(address + (_EVENT_DATA_DESCRIPTOR.SIZEOF * count));
	}

	public _EVENT_DATA_DESCRIPTORPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _EVENT_DATA_DESCRIPTORPointer addOffset(long offset) {
		return _EVENT_DATA_DESCRIPTORPointer.cast(address + offset);
	}

	public _EVENT_DATA_DESCRIPTORPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _EVENT_DATA_DESCRIPTORPointer sub(long count) {
		return _EVENT_DATA_DESCRIPTORPointer.cast(address - (_EVENT_DATA_DESCRIPTOR.SIZEOF * count));
	}

	public _EVENT_DATA_DESCRIPTORPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _EVENT_DATA_DESCRIPTORPointer subOffset(long offset) {
		return _EVENT_DATA_DESCRIPTORPointer.cast(address - offset);
	}

	public _EVENT_DATA_DESCRIPTORPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _EVENT_DATA_DESCRIPTORPointer untag(long mask) {
		return _EVENT_DATA_DESCRIPTORPointer.cast(address & ~mask);
	}

	public _EVENT_DATA_DESCRIPTORPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _EVENT_DATA_DESCRIPTOR.SIZEOF;
	}

	// Implementation methods

	// U64 Ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PtrOffset_", declaredType="U64")
	public UDATA Ptr() throws CorruptDataException {
		return new U64(getLongAtOffset(_EVENT_DATA_DESCRIPTOR._PtrOffset_));
	}

	// U64 Ptr
	public UDATAPointer PtrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EVENT_DATA_DESCRIPTOR._PtrOffset_));
	}

	// U32 Reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedOffset_", declaredType="U32")
	public UDATA Reserved() throws CorruptDataException {
		return new U32(getIntAtOffset(_EVENT_DATA_DESCRIPTOR._ReservedOffset_));
	}

	// U32 Reserved
	public UDATAPointer ReservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EVENT_DATA_DESCRIPTOR._ReservedOffset_));
	}

	// U8 Reserved1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved1Offset_", declaredType="U8")
	public U8 Reserved1() throws CorruptDataException {
		return new U8(getByteAtOffset(_EVENT_DATA_DESCRIPTOR._Reserved1Offset_));
	}

	// U8 Reserved1
	public U8Pointer Reserved1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_EVENT_DATA_DESCRIPTOR._Reserved1Offset_));
	}

	// U16 Reserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved2Offset_", declaredType="U16")
	public U16 Reserved2() throws CorruptDataException {
		return new U16(getShortAtOffset(_EVENT_DATA_DESCRIPTOR._Reserved2Offset_));
	}

	// U16 Reserved2
	public U16Pointer Reserved2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_EVENT_DATA_DESCRIPTOR._Reserved2Offset_));
	}

	// U32 Size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOffset_", declaredType="U32")
	public UDATA Size() throws CorruptDataException {
		return new U32(getIntAtOffset(_EVENT_DATA_DESCRIPTOR._SizeOffset_));
	}

	// U32 Size
	public UDATAPointer SizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EVENT_DATA_DESCRIPTOR._SizeOffset_));
	}

	// U8 Type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TypeOffset_", declaredType="U8")
	public U8 Type() throws CorruptDataException {
		return new U8(getByteAtOffset(_EVENT_DATA_DESCRIPTOR._TypeOffset_));
	}

	// U8 Type
	public U8Pointer TypeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_EVENT_DATA_DESCRIPTOR._TypeOffset_));
	}

}
