/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _GS_HANDLER_DATAPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _GS_HANDLER_DATAPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_GS_HANDLER_DATA.class)
public class _GS_HANDLER_DATAPointer extends StructurePointer {

	// NULL
	public static final _GS_HANDLER_DATAPointer NULL = new _GS_HANDLER_DATAPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _GS_HANDLER_DATAPointer(long address) {
		super(address);
	}

	public static _GS_HANDLER_DATAPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _GS_HANDLER_DATAPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _GS_HANDLER_DATAPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _GS_HANDLER_DATAPointer(address);
	}

	public _GS_HANDLER_DATAPointer add(long count) {
		return _GS_HANDLER_DATAPointer.cast(address + (_GS_HANDLER_DATA.SIZEOF * count));
	}

	public _GS_HANDLER_DATAPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _GS_HANDLER_DATAPointer addOffset(long offset) {
		return _GS_HANDLER_DATAPointer.cast(address + offset);
	}

	public _GS_HANDLER_DATAPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _GS_HANDLER_DATAPointer sub(long count) {
		return _GS_HANDLER_DATAPointer.cast(address - (_GS_HANDLER_DATA.SIZEOF * count));
	}

	public _GS_HANDLER_DATAPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _GS_HANDLER_DATAPointer subOffset(long offset) {
		return _GS_HANDLER_DATAPointer.cast(address - offset);
	}

	public _GS_HANDLER_DATAPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _GS_HANDLER_DATAPointer untag(long mask) {
		return _GS_HANDLER_DATAPointer.cast(address & ~mask);
	}

	public _GS_HANDLER_DATAPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _GS_HANDLER_DATA.SIZEOF;
	}

	// Implementation methods

	// I32 AlignedBaseOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AlignedBaseOffsetOffset_", declaredType="I32")
	public IDATA AlignedBaseOffset() throws CorruptDataException {
		return new I32(getIntAtOffset(_GS_HANDLER_DATA._AlignedBaseOffsetOffset_));
	}

	// I32 AlignedBaseOffset
	public IDATAPointer AlignedBaseOffsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_GS_HANDLER_DATA._AlignedBaseOffsetOffset_));
	}

	// I32 Alignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AlignmentOffset_", declaredType="I32")
	public IDATA Alignment() throws CorruptDataException {
		return new I32(getIntAtOffset(_GS_HANDLER_DATA._AlignmentOffset_));
	}

	// I32 Alignment
	public IDATAPointer AlignmentEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_GS_HANDLER_DATA._AlignmentOffset_));
	}

	// U32:1 u.Bits.EHandler
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$Bits$EHandlerOffset_", declaredType="U32:1")
	public UDATA u$Bits$EHandler() throws CorruptDataException {
		return getU32Bitfield(_GS_HANDLER_DATA._u$Bits$EHandler_s_, _GS_HANDLER_DATA._u$Bits$EHandler_b_);
	}

	// U32:1 u.Bits.HasAlignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$Bits$HasAlignmentOffset_", declaredType="U32:1")
	public UDATA u$Bits$HasAlignment() throws CorruptDataException {
		return getU32Bitfield(_GS_HANDLER_DATA._u$Bits$HasAlignment_s_, _GS_HANDLER_DATA._u$Bits$HasAlignment_b_);
	}

	// U32:1 u.Bits.UHandler
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$Bits$UHandlerOffset_", declaredType="U32:1")
	public UDATA u$Bits$UHandler() throws CorruptDataException {
		return getU32Bitfield(_GS_HANDLER_DATA._u$Bits$UHandler_s_, _GS_HANDLER_DATA._u$Bits$UHandler_b_);
	}

	// I32 u.CookieOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u$CookieOffsetOffset_", declaredType="I32")
	public IDATA u$CookieOffset() throws CorruptDataException {
		return new I32(getIntAtOffset(_GS_HANDLER_DATA._u$CookieOffsetOffset_));
	}

	// I32 u.CookieOffset
	public IDATAPointer u$CookieOffsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_GS_HANDLER_DATA._u$CookieOffsetOffset_));
	}

}
