/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGE_DOS_HEADERPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGE_DOS_HEADERPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGE_DOS_HEADER.class)
public class _IMAGE_DOS_HEADERPointer extends StructurePointer {

	// NULL
	public static final _IMAGE_DOS_HEADERPointer NULL = new _IMAGE_DOS_HEADERPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGE_DOS_HEADERPointer(long address) {
		super(address);
	}

	public static _IMAGE_DOS_HEADERPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGE_DOS_HEADERPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGE_DOS_HEADERPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGE_DOS_HEADERPointer(address);
	}

	public _IMAGE_DOS_HEADERPointer add(long count) {
		return _IMAGE_DOS_HEADERPointer.cast(address + (_IMAGE_DOS_HEADER.SIZEOF * count));
	}

	public _IMAGE_DOS_HEADERPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGE_DOS_HEADERPointer addOffset(long offset) {
		return _IMAGE_DOS_HEADERPointer.cast(address + offset);
	}

	public _IMAGE_DOS_HEADERPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGE_DOS_HEADERPointer sub(long count) {
		return _IMAGE_DOS_HEADERPointer.cast(address - (_IMAGE_DOS_HEADER.SIZEOF * count));
	}

	public _IMAGE_DOS_HEADERPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGE_DOS_HEADERPointer subOffset(long offset) {
		return _IMAGE_DOS_HEADERPointer.cast(address - offset);
	}

	public _IMAGE_DOS_HEADERPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGE_DOS_HEADERPointer untag(long mask) {
		return _IMAGE_DOS_HEADERPointer.cast(address & ~mask);
	}

	public _IMAGE_DOS_HEADERPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGE_DOS_HEADER.SIZEOF;
	}

	// Implementation methods

	// U16 e_cblp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_cblpOffset_", declaredType="U16")
	public U16 e_cblp() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_cblpOffset_));
	}

	// U16 e_cblp
	public U16Pointer e_cblpEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_cblpOffset_));
	}

	// U16 e_cp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_cpOffset_", declaredType="U16")
	public U16 e_cp() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_cpOffset_));
	}

	// U16 e_cp
	public U16Pointer e_cpEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_cpOffset_));
	}

	// U16 e_cparhdr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_cparhdrOffset_", declaredType="U16")
	public U16 e_cparhdr() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_cparhdrOffset_));
	}

	// U16 e_cparhdr
	public U16Pointer e_cparhdrEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_cparhdrOffset_));
	}

	// U16 e_crlc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_crlcOffset_", declaredType="U16")
	public U16 e_crlc() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_crlcOffset_));
	}

	// U16 e_crlc
	public U16Pointer e_crlcEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_crlcOffset_));
	}

	// U16 e_cs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_csOffset_", declaredType="U16")
	public U16 e_cs() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_csOffset_));
	}

	// U16 e_cs
	public U16Pointer e_csEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_csOffset_));
	}

	// U16 e_csum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_csumOffset_", declaredType="U16")
	public U16 e_csum() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_csumOffset_));
	}

	// U16 e_csum
	public U16Pointer e_csumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_csumOffset_));
	}

	// U16 e_ip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_ipOffset_", declaredType="U16")
	public U16 e_ip() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_ipOffset_));
	}

	// U16 e_ip
	public U16Pointer e_ipEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_ipOffset_));
	}

	// I32 e_lfanew
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_lfanewOffset_", declaredType="I32")
	public IDATA e_lfanew() throws CorruptDataException {
		return new I32(getIntAtOffset(_IMAGE_DOS_HEADER._e_lfanewOffset_));
	}

	// I32 e_lfanew
	public IDATAPointer e_lfanewEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_lfanewOffset_));
	}

	// U16 e_lfarlc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_lfarlcOffset_", declaredType="U16")
	public U16 e_lfarlc() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_lfarlcOffset_));
	}

	// U16 e_lfarlc
	public U16Pointer e_lfarlcEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_lfarlcOffset_));
	}

	// U16 e_magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_magicOffset_", declaredType="U16")
	public U16 e_magic() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_magicOffset_));
	}

	// U16 e_magic
	public U16Pointer e_magicEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_magicOffset_));
	}

	// U16 e_maxalloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_maxallocOffset_", declaredType="U16")
	public U16 e_maxalloc() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_maxallocOffset_));
	}

	// U16 e_maxalloc
	public U16Pointer e_maxallocEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_maxallocOffset_));
	}

	// U16 e_minalloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_minallocOffset_", declaredType="U16")
	public U16 e_minalloc() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_minallocOffset_));
	}

	// U16 e_minalloc
	public U16Pointer e_minallocEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_minallocOffset_));
	}

	// U16 e_oemid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_oemidOffset_", declaredType="U16")
	public U16 e_oemid() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_oemidOffset_));
	}

	// U16 e_oemid
	public U16Pointer e_oemidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_oemidOffset_));
	}

	// U16 e_oeminfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_oeminfoOffset_", declaredType="U16")
	public U16 e_oeminfo() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_oeminfoOffset_));
	}

	// U16 e_oeminfo
	public U16Pointer e_oeminfoEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_oeminfoOffset_));
	}

	// U16 e_ovno
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_ovnoOffset_", declaredType="U16")
	public U16 e_ovno() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_ovnoOffset_));
	}

	// U16 e_ovno
	public U16Pointer e_ovnoEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_ovnoOffset_));
	}

	// U16[] e_res
	public U16Pointer e_resEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_resOffset_));
	}

	// U16[] e_res2
	public U16Pointer e_res2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_res2Offset_));
	}

	// U16 e_sp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_spOffset_", declaredType="U16")
	public U16 e_sp() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_spOffset_));
	}

	// U16 e_sp
	public U16Pointer e_spEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_spOffset_));
	}

	// U16 e_ss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_ssOffset_", declaredType="U16")
	public U16 e_ss() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_DOS_HEADER._e_ssOffset_));
	}

	// U16 e_ss
	public U16Pointer e_ssEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_DOS_HEADER._e_ssOffset_));
	}

}
