/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGE_FILE_HEADERPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGE_FILE_HEADERPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGE_FILE_HEADER.class)
public class _IMAGE_FILE_HEADERPointer extends StructurePointer {

	// NULL
	public static final _IMAGE_FILE_HEADERPointer NULL = new _IMAGE_FILE_HEADERPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGE_FILE_HEADERPointer(long address) {
		super(address);
	}

	public static _IMAGE_FILE_HEADERPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGE_FILE_HEADERPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGE_FILE_HEADERPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGE_FILE_HEADERPointer(address);
	}

	public _IMAGE_FILE_HEADERPointer add(long count) {
		return _IMAGE_FILE_HEADERPointer.cast(address + (_IMAGE_FILE_HEADER.SIZEOF * count));
	}

	public _IMAGE_FILE_HEADERPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGE_FILE_HEADERPointer addOffset(long offset) {
		return _IMAGE_FILE_HEADERPointer.cast(address + offset);
	}

	public _IMAGE_FILE_HEADERPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGE_FILE_HEADERPointer sub(long count) {
		return _IMAGE_FILE_HEADERPointer.cast(address - (_IMAGE_FILE_HEADER.SIZEOF * count));
	}

	public _IMAGE_FILE_HEADERPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGE_FILE_HEADERPointer subOffset(long offset) {
		return _IMAGE_FILE_HEADERPointer.cast(address - offset);
	}

	public _IMAGE_FILE_HEADERPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGE_FILE_HEADERPointer untag(long mask) {
		return _IMAGE_FILE_HEADERPointer.cast(address & ~mask);
	}

	public _IMAGE_FILE_HEADERPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGE_FILE_HEADER.SIZEOF;
	}

	// Implementation methods

	// U16 Characteristics
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CharacteristicsOffset_", declaredType="U16")
	public U16 Characteristics() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_FILE_HEADER._CharacteristicsOffset_));
	}

	// U16 Characteristics
	public U16Pointer CharacteristicsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._CharacteristicsOffset_));
	}

	// U16 Machine
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MachineOffset_", declaredType="U16")
	public U16 Machine() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_FILE_HEADER._MachineOffset_));
	}

	// U16 Machine
	public U16Pointer MachineEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._MachineOffset_));
	}

	// U16 NumberOfSections
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberOfSectionsOffset_", declaredType="U16")
	public U16 NumberOfSections() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_FILE_HEADER._NumberOfSectionsOffset_));
	}

	// U16 NumberOfSections
	public U16Pointer NumberOfSectionsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._NumberOfSectionsOffset_));
	}

	// U32 NumberOfSymbols
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberOfSymbolsOffset_", declaredType="U32")
	public UDATA NumberOfSymbols() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_FILE_HEADER._NumberOfSymbolsOffset_));
	}

	// U32 NumberOfSymbols
	public UDATAPointer NumberOfSymbolsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._NumberOfSymbolsOffset_));
	}

	// U32 PointerToSymbolTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PointerToSymbolTableOffset_", declaredType="U32")
	public UDATA PointerToSymbolTable() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_FILE_HEADER._PointerToSymbolTableOffset_));
	}

	// U32 PointerToSymbolTable
	public UDATAPointer PointerToSymbolTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._PointerToSymbolTableOffset_));
	}

	// U16 SizeOfOptionalHeader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfOptionalHeaderOffset_", declaredType="U16")
	public U16 SizeOfOptionalHeader() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_FILE_HEADER._SizeOfOptionalHeaderOffset_));
	}

	// U16 SizeOfOptionalHeader
	public U16Pointer SizeOfOptionalHeaderEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._SizeOfOptionalHeaderOffset_));
	}

	// U32 TimeDateStamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TimeDateStampOffset_", declaredType="U32")
	public UDATA TimeDateStamp() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_FILE_HEADER._TimeDateStampOffset_));
	}

	// U32 TimeDateStamp
	public UDATAPointer TimeDateStampEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_FILE_HEADER._TimeDateStampOffset_));
	}

}
