/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _MINIDUMP_CALLBACK_INPUTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _MINIDUMP_CALLBACK_INPUTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_MINIDUMP_CALLBACK_INPUT.class)
public class _MINIDUMP_CALLBACK_INPUTPointer extends StructurePointer {

	// NULL
	public static final _MINIDUMP_CALLBACK_INPUTPointer NULL = new _MINIDUMP_CALLBACK_INPUTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _MINIDUMP_CALLBACK_INPUTPointer(long address) {
		super(address);
	}

	public static _MINIDUMP_CALLBACK_INPUTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _MINIDUMP_CALLBACK_INPUTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _MINIDUMP_CALLBACK_INPUTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _MINIDUMP_CALLBACK_INPUTPointer(address);
	}

	public _MINIDUMP_CALLBACK_INPUTPointer add(long count) {
		return _MINIDUMP_CALLBACK_INPUTPointer.cast(address + (_MINIDUMP_CALLBACK_INPUT.SIZEOF * count));
	}

	public _MINIDUMP_CALLBACK_INPUTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _MINIDUMP_CALLBACK_INPUTPointer addOffset(long offset) {
		return _MINIDUMP_CALLBACK_INPUTPointer.cast(address + offset);
	}

	public _MINIDUMP_CALLBACK_INPUTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _MINIDUMP_CALLBACK_INPUTPointer sub(long count) {
		return _MINIDUMP_CALLBACK_INPUTPointer.cast(address - (_MINIDUMP_CALLBACK_INPUT.SIZEOF * count));
	}

	public _MINIDUMP_CALLBACK_INPUTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _MINIDUMP_CALLBACK_INPUTPointer subOffset(long offset) {
		return _MINIDUMP_CALLBACK_INPUTPointer.cast(address - offset);
	}

	public _MINIDUMP_CALLBACK_INPUTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _MINIDUMP_CALLBACK_INPUTPointer untag(long mask) {
		return _MINIDUMP_CALLBACK_INPUTPointer.cast(address & ~mask);
	}

	public _MINIDUMP_CALLBACK_INPUTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _MINIDUMP_CALLBACK_INPUT.SIZEOF;
	}

	// Implementation methods

	// U32 CallbackType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CallbackTypeOffset_", declaredType="U32")
	public UDATA CallbackType() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_INPUT._CallbackTypeOffset_));
	}

	// U32 CallbackType
	public UDATAPointer CallbackTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._CallbackTypeOffset_));
	}

	// _MINIDUMP_INCLUDE_MODULE_CALLBACK IncludeModule
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IncludeModuleOffset_", declaredType="_MINIDUMP_INCLUDE_MODULE_CALLBACK")
	public _MINIDUMP_INCLUDE_MODULE_CALLBACKPointer IncludeModule() throws CorruptDataException {
		return _MINIDUMP_INCLUDE_MODULE_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._IncludeModuleOffset_));
	}

	// _MINIDUMP_INCLUDE_MODULE_CALLBACK IncludeModule
	public PointerPointer IncludeModuleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._IncludeModuleOffset_));
	}

	// _MINIDUMP_INCLUDE_THREAD_CALLBACK IncludeThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IncludeThreadOffset_", declaredType="_MINIDUMP_INCLUDE_THREAD_CALLBACK")
	public _MINIDUMP_INCLUDE_THREAD_CALLBACKPointer IncludeThread() throws CorruptDataException {
		return _MINIDUMP_INCLUDE_THREAD_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._IncludeThreadOffset_));
	}

	// _MINIDUMP_INCLUDE_THREAD_CALLBACK IncludeThread
	public PointerPointer IncludeThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._IncludeThreadOffset_));
	}

	// _MINIDUMP_IO_CALLBACK Io
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IoOffset_", declaredType="_MINIDUMP_IO_CALLBACK")
	public _MINIDUMP_IO_CALLBACKPointer Io() throws CorruptDataException {
		return _MINIDUMP_IO_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._IoOffset_));
	}

	// _MINIDUMP_IO_CALLBACK Io
	public PointerPointer IoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._IoOffset_));
	}

	// _MINIDUMP_MODULE_CALLBACK Module
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ModuleOffset_", declaredType="_MINIDUMP_MODULE_CALLBACK")
	public _MINIDUMP_MODULE_CALLBACKPointer Module() throws CorruptDataException {
		return _MINIDUMP_MODULE_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ModuleOffset_));
	}

	// _MINIDUMP_MODULE_CALLBACK Module
	public PointerPointer ModuleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ModuleOffset_));
	}

	// void* ProcessHandle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessHandleOffset_", declaredType="void*")
	public VoidPointer ProcessHandle() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_MINIDUMP_CALLBACK_INPUT._ProcessHandleOffset_));
	}

	// void* ProcessHandle
	public PointerPointer ProcessHandleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ProcessHandleOffset_));
	}

	// U32 ProcessId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessIdOffset_", declaredType="U32")
	public UDATA ProcessId() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_INPUT._ProcessIdOffset_));
	}

	// U32 ProcessId
	public UDATAPointer ProcessIdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ProcessIdOffset_));
	}

	// _MINIDUMP_READ_MEMORY_FAILURE_CALLBACK ReadMemoryFailure
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReadMemoryFailureOffset_", declaredType="_MINIDUMP_READ_MEMORY_FAILURE_CALLBACK")
	public _MINIDUMP_READ_MEMORY_FAILURE_CALLBACKPointer ReadMemoryFailure() throws CorruptDataException {
		return _MINIDUMP_READ_MEMORY_FAILURE_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ReadMemoryFailureOffset_));
	}

	// _MINIDUMP_READ_MEMORY_FAILURE_CALLBACK ReadMemoryFailure
	public PointerPointer ReadMemoryFailureEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ReadMemoryFailureOffset_));
	}

	// U32 SecondaryFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SecondaryFlagsOffset_", declaredType="U32")
	public UDATA SecondaryFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_INPUT._SecondaryFlagsOffset_));
	}

	// U32 SecondaryFlags
	public UDATAPointer SecondaryFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._SecondaryFlagsOffset_));
	}

	// _MINIDUMP_THREAD_CALLBACK Thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThreadOffset_", declaredType="_MINIDUMP_THREAD_CALLBACK")
	public _MINIDUMP_THREAD_CALLBACKPointer Thread() throws CorruptDataException {
		return _MINIDUMP_THREAD_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ThreadOffset_));
	}

	// _MINIDUMP_THREAD_CALLBACK Thread
	public PointerPointer ThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ThreadOffset_));
	}

	// _MINIDUMP_THREAD_EX_CALLBACK ThreadEx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThreadExOffset_", declaredType="_MINIDUMP_THREAD_EX_CALLBACK")
	public _MINIDUMP_THREAD_EX_CALLBACKPointer ThreadEx() throws CorruptDataException {
		return _MINIDUMP_THREAD_EX_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ThreadExOffset_));
	}

	// _MINIDUMP_THREAD_EX_CALLBACK ThreadEx
	public PointerPointer ThreadExEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._ThreadExOffset_));
	}

	// _MINIDUMP_VM_POST_READ_CALLBACK VmPostRead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VmPostReadOffset_", declaredType="_MINIDUMP_VM_POST_READ_CALLBACK")
	public _MINIDUMP_VM_POST_READ_CALLBACKPointer VmPostRead() throws CorruptDataException {
		return _MINIDUMP_VM_POST_READ_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._VmPostReadOffset_));
	}

	// _MINIDUMP_VM_POST_READ_CALLBACK VmPostRead
	public PointerPointer VmPostReadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._VmPostReadOffset_));
	}

	// _MINIDUMP_VM_PRE_READ_CALLBACK VmPreRead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VmPreReadOffset_", declaredType="_MINIDUMP_VM_PRE_READ_CALLBACK")
	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer VmPreRead() throws CorruptDataException {
		return _MINIDUMP_VM_PRE_READ_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._VmPreReadOffset_));
	}

	// _MINIDUMP_VM_PRE_READ_CALLBACK VmPreRead
	public PointerPointer VmPreReadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._VmPreReadOffset_));
	}

	// _MINIDUMP_VM_QUERY_CALLBACK VmQuery
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VmQueryOffset_", declaredType="_MINIDUMP_VM_QUERY_CALLBACK")
	public _MINIDUMP_VM_QUERY_CALLBACKPointer VmQuery() throws CorruptDataException {
		return _MINIDUMP_VM_QUERY_CALLBACKPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._VmQueryOffset_));
	}

	// _MINIDUMP_VM_QUERY_CALLBACK VmQuery
	public PointerPointer VmQueryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_INPUT._VmQueryOffset_));
	}

}
