/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _MINIDUMP_CALLBACK_OUTPUTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _MINIDUMP_CALLBACK_OUTPUTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_MINIDUMP_CALLBACK_OUTPUT.class)
public class _MINIDUMP_CALLBACK_OUTPUTPointer extends StructurePointer {

	// NULL
	public static final _MINIDUMP_CALLBACK_OUTPUTPointer NULL = new _MINIDUMP_CALLBACK_OUTPUTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _MINIDUMP_CALLBACK_OUTPUTPointer(long address) {
		super(address);
	}

	public static _MINIDUMP_CALLBACK_OUTPUTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _MINIDUMP_CALLBACK_OUTPUTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _MINIDUMP_CALLBACK_OUTPUTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _MINIDUMP_CALLBACK_OUTPUTPointer(address);
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer add(long count) {
		return _MINIDUMP_CALLBACK_OUTPUTPointer.cast(address + (_MINIDUMP_CALLBACK_OUTPUT.SIZEOF * count));
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer addOffset(long offset) {
		return _MINIDUMP_CALLBACK_OUTPUTPointer.cast(address + offset);
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer sub(long count) {
		return _MINIDUMP_CALLBACK_OUTPUTPointer.cast(address - (_MINIDUMP_CALLBACK_OUTPUT.SIZEOF * count));
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer subOffset(long offset) {
		return _MINIDUMP_CALLBACK_OUTPUTPointer.cast(address - offset);
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer untag(long mask) {
		return _MINIDUMP_CALLBACK_OUTPUTPointer.cast(address & ~mask);
	}

	public _MINIDUMP_CALLBACK_OUTPUTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _MINIDUMP_CALLBACK_OUTPUT.SIZEOF;
	}

	// Implementation methods

	// I32 Cancel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CancelOffset_", declaredType="I32")
	public IDATA Cancel() throws CorruptDataException {
		return new I32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._CancelOffset_));
	}

	// I32 Cancel
	public IDATAPointer CancelEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._CancelOffset_));
	}

	// I32 CheckCancel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CheckCancelOffset_", declaredType="I32")
	public IDATA CheckCancel() throws CorruptDataException {
		return new I32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._CheckCancelOffset_));
	}

	// I32 CheckCancel
	public IDATAPointer CheckCancelEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._CheckCancelOffset_));
	}

	// I32 Continue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ContinueOffset_", declaredType="I32")
	public IDATA Continue() throws CorruptDataException {
		return new I32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._ContinueOffset_));
	}

	// I32 Continue
	public IDATAPointer ContinueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._ContinueOffset_));
	}

	// void* Handle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_HandleOffset_", declaredType="void*")
	public VoidPointer Handle() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_MINIDUMP_CALLBACK_OUTPUT._HandleOffset_));
	}

	// void* Handle
	public PointerPointer HandleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._HandleOffset_));
	}

	// U64 MemoryBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MemoryBaseOffset_", declaredType="U64")
	public UDATA MemoryBase() throws CorruptDataException {
		return new U64(getLongAtOffset(_MINIDUMP_CALLBACK_OUTPUT._MemoryBaseOffset_));
	}

	// U64 MemoryBase
	public UDATAPointer MemoryBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._MemoryBaseOffset_));
	}

	// U32 MemorySize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MemorySizeOffset_", declaredType="U32")
	public UDATA MemorySize() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._MemorySizeOffset_));
	}

	// U32 MemorySize
	public UDATAPointer MemorySizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._MemorySizeOffset_));
	}

	// U32 ModuleWriteFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ModuleWriteFlagsOffset_", declaredType="U32")
	public UDATA ModuleWriteFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._ModuleWriteFlagsOffset_));
	}

	// U32 ModuleWriteFlags
	public UDATAPointer ModuleWriteFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._ModuleWriteFlagsOffset_));
	}

	// U32 SecondaryFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SecondaryFlagsOffset_", declaredType="U32")
	public UDATA SecondaryFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._SecondaryFlagsOffset_));
	}

	// U32 SecondaryFlags
	public UDATAPointer SecondaryFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._SecondaryFlagsOffset_));
	}

	// U32 ThreadWriteFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThreadWriteFlagsOffset_", declaredType="U32")
	public UDATA ThreadWriteFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._ThreadWriteFlagsOffset_));
	}

	// U32 ThreadWriteFlags
	public UDATAPointer ThreadWriteFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._ThreadWriteFlagsOffset_));
	}

	// _MINIDUMP_MEMORY_INFO VmQueryResult
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VmQueryResultOffset_", declaredType="_MINIDUMP_MEMORY_INFO")
	public _MINIDUMP_MEMORY_INFOPointer VmQueryResult() throws CorruptDataException {
		return _MINIDUMP_MEMORY_INFOPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._VmQueryResultOffset_));
	}

	// _MINIDUMP_MEMORY_INFO VmQueryResult
	public PointerPointer VmQueryResultEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._VmQueryResultOffset_));
	}

	// U32 VmReadBytesCompleted
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VmReadBytesCompletedOffset_", declaredType="U32")
	public UDATA VmReadBytesCompleted() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_CALLBACK_OUTPUT._VmReadBytesCompletedOffset_));
	}

	// U32 VmReadBytesCompleted
	public UDATAPointer VmReadBytesCompletedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._VmReadBytesCompletedOffset_));
	}

	// _MINIDUMP_MEMORY_INFO VmRegion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VmRegionOffset_", declaredType="_MINIDUMP_MEMORY_INFO")
	public _MINIDUMP_MEMORY_INFOPointer VmRegion() throws CorruptDataException {
		return _MINIDUMP_MEMORY_INFOPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._VmRegionOffset_));
	}

	// _MINIDUMP_MEMORY_INFO VmRegion
	public PointerPointer VmRegionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_CALLBACK_OUTPUT._VmRegionOffset_));
	}

}
