/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _OSVERSIONINFOEXWPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _OSVERSIONINFOEXWPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_OSVERSIONINFOEXW.class)
public class _OSVERSIONINFOEXWPointer extends StructurePointer {

	// NULL
	public static final _OSVERSIONINFOEXWPointer NULL = new _OSVERSIONINFOEXWPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _OSVERSIONINFOEXWPointer(long address) {
		super(address);
	}

	public static _OSVERSIONINFOEXWPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _OSVERSIONINFOEXWPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _OSVERSIONINFOEXWPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _OSVERSIONINFOEXWPointer(address);
	}

	public _OSVERSIONINFOEXWPointer add(long count) {
		return _OSVERSIONINFOEXWPointer.cast(address + (_OSVERSIONINFOEXW.SIZEOF * count));
	}

	public _OSVERSIONINFOEXWPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _OSVERSIONINFOEXWPointer addOffset(long offset) {
		return _OSVERSIONINFOEXWPointer.cast(address + offset);
	}

	public _OSVERSIONINFOEXWPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _OSVERSIONINFOEXWPointer sub(long count) {
		return _OSVERSIONINFOEXWPointer.cast(address - (_OSVERSIONINFOEXW.SIZEOF * count));
	}

	public _OSVERSIONINFOEXWPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _OSVERSIONINFOEXWPointer subOffset(long offset) {
		return _OSVERSIONINFOEXWPointer.cast(address - offset);
	}

	public _OSVERSIONINFOEXWPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _OSVERSIONINFOEXWPointer untag(long mask) {
		return _OSVERSIONINFOEXWPointer.cast(address & ~mask);
	}

	public _OSVERSIONINFOEXWPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _OSVERSIONINFOEXW.SIZEOF;
	}

	// Implementation methods

	// U32 dwBuildNumber
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwBuildNumberOffset_", declaredType="U32")
	public UDATA dwBuildNumber() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOEXW._dwBuildNumberOffset_));
	}

	// U32 dwBuildNumber
	public UDATAPointer dwBuildNumberEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._dwBuildNumberOffset_));
	}

	// U32 dwMajorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwMajorVersionOffset_", declaredType="U32")
	public UDATA dwMajorVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOEXW._dwMajorVersionOffset_));
	}

	// U32 dwMajorVersion
	public UDATAPointer dwMajorVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._dwMajorVersionOffset_));
	}

	// U32 dwMinorVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwMinorVersionOffset_", declaredType="U32")
	public UDATA dwMinorVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOEXW._dwMinorVersionOffset_));
	}

	// U32 dwMinorVersion
	public UDATAPointer dwMinorVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._dwMinorVersionOffset_));
	}

	// U32 dwOSVersionInfoSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwOSVersionInfoSizeOffset_", declaredType="U32")
	public UDATA dwOSVersionInfoSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOEXW._dwOSVersionInfoSizeOffset_));
	}

	// U32 dwOSVersionInfoSize
	public UDATAPointer dwOSVersionInfoSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._dwOSVersionInfoSizeOffset_));
	}

	// U32 dwPlatformId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwPlatformIdOffset_", declaredType="U32")
	public UDATA dwPlatformId() throws CorruptDataException {
		return new U32(getIntAtOffset(_OSVERSIONINFOEXW._dwPlatformIdOffset_));
	}

	// U32 dwPlatformId
	public UDATAPointer dwPlatformIdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._dwPlatformIdOffset_));
	}

	// U16[] szCSDVersion
	public U16Pointer szCSDVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._szCSDVersionOffset_));
	}

	// U8 wProductType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wProductTypeOffset_", declaredType="U8")
	public U8 wProductType() throws CorruptDataException {
		return new U8(getByteAtOffset(_OSVERSIONINFOEXW._wProductTypeOffset_));
	}

	// U8 wProductType
	public U8Pointer wProductTypeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._wProductTypeOffset_));
	}

	// U8 wReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReservedOffset_", declaredType="U8")
	public U8 wReserved() throws CorruptDataException {
		return new U8(getByteAtOffset(_OSVERSIONINFOEXW._wReservedOffset_));
	}

	// U8 wReserved
	public U8Pointer wReservedEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._wReservedOffset_));
	}

	// U16 wServicePackMajor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wServicePackMajorOffset_", declaredType="U16")
	public U16 wServicePackMajor() throws CorruptDataException {
		return new U16(getShortAtOffset(_OSVERSIONINFOEXW._wServicePackMajorOffset_));
	}

	// U16 wServicePackMajor
	public U16Pointer wServicePackMajorEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._wServicePackMajorOffset_));
	}

	// U16 wServicePackMinor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wServicePackMinorOffset_", declaredType="U16")
	public U16 wServicePackMinor() throws CorruptDataException {
		return new U16(getShortAtOffset(_OSVERSIONINFOEXW._wServicePackMinorOffset_));
	}

	// U16 wServicePackMinor
	public U16Pointer wServicePackMinorEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._wServicePackMinorOffset_));
	}

	// U16 wSuiteMask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wSuiteMaskOffset_", declaredType="U16")
	public U16 wSuiteMask() throws CorruptDataException {
		return new U16(getShortAtOffset(_OSVERSIONINFOEXW._wSuiteMaskOffset_));
	}

	// U16 wSuiteMask
	public U16Pointer wSuiteMaskEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_OSVERSIONINFOEXW._wSuiteMaskOffset_));
	}

}
