/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _PDH_RAW_COUNTERPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _PDH_RAW_COUNTERPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_PDH_RAW_COUNTER.class)
public class _PDH_RAW_COUNTERPointer extends StructurePointer {

	// NULL
	public static final _PDH_RAW_COUNTERPointer NULL = new _PDH_RAW_COUNTERPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _PDH_RAW_COUNTERPointer(long address) {
		super(address);
	}

	public static _PDH_RAW_COUNTERPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _PDH_RAW_COUNTERPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _PDH_RAW_COUNTERPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _PDH_RAW_COUNTERPointer(address);
	}

	public _PDH_RAW_COUNTERPointer add(long count) {
		return _PDH_RAW_COUNTERPointer.cast(address + (_PDH_RAW_COUNTER.SIZEOF * count));
	}

	public _PDH_RAW_COUNTERPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _PDH_RAW_COUNTERPointer addOffset(long offset) {
		return _PDH_RAW_COUNTERPointer.cast(address + offset);
	}

	public _PDH_RAW_COUNTERPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _PDH_RAW_COUNTERPointer sub(long count) {
		return _PDH_RAW_COUNTERPointer.cast(address - (_PDH_RAW_COUNTER.SIZEOF * count));
	}

	public _PDH_RAW_COUNTERPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _PDH_RAW_COUNTERPointer subOffset(long offset) {
		return _PDH_RAW_COUNTERPointer.cast(address - offset);
	}

	public _PDH_RAW_COUNTERPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _PDH_RAW_COUNTERPointer untag(long mask) {
		return _PDH_RAW_COUNTERPointer.cast(address & ~mask);
	}

	public _PDH_RAW_COUNTERPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _PDH_RAW_COUNTER.SIZEOF;
	}

	// Implementation methods

	// volatile U32 CStatus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CStatusOffset_", declaredType="volatile U32")
	public UDATA CStatus() throws CorruptDataException {
		return new U32(getIntAtOffset(_PDH_RAW_COUNTER._CStatusOffset_));
	}

	// volatile U32 CStatus
	public UDATAPointer CStatusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PDH_RAW_COUNTER._CStatusOffset_));
	}

	// I64 FirstValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FirstValueOffset_", declaredType="I64")
	public IDATA FirstValue() throws CorruptDataException {
		return new I64(getLongAtOffset(_PDH_RAW_COUNTER._FirstValueOffset_));
	}

	// I64 FirstValue
	public IDATAPointer FirstValueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_PDH_RAW_COUNTER._FirstValueOffset_));
	}

	// U32 MultiCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MultiCountOffset_", declaredType="U32")
	public UDATA MultiCount() throws CorruptDataException {
		return new U32(getIntAtOffset(_PDH_RAW_COUNTER._MultiCountOffset_));
	}

	// U32 MultiCount
	public UDATAPointer MultiCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PDH_RAW_COUNTER._MultiCountOffset_));
	}

	// I64 SecondValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SecondValueOffset_", declaredType="I64")
	public IDATA SecondValue() throws CorruptDataException {
		return new I64(getLongAtOffset(_PDH_RAW_COUNTER._SecondValueOffset_));
	}

	// I64 SecondValue
	public IDATAPointer SecondValueEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_PDH_RAW_COUNTER._SecondValueOffset_));
	}

	// _FILETIME TimeStamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TimeStampOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer TimeStamp() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(_PDH_RAW_COUNTER._TimeStampOffset_));
	}

	// _FILETIME TimeStamp
	public PointerPointer TimeStampEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PDH_RAW_COUNTER._TimeStampOffset_));
	}

}
