/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY.class)
public class _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer extends StructurePointer {

	// NULL
	public static final _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer NULL = new _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer(long address) {
		super(address);
	}

	public static _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer(address);
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer add(long count) {
		return _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer.cast(address + (_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY.SIZEOF * count));
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer addOffset(long offset) {
		return _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer.cast(address + offset);
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer sub(long count) {
		return _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer.cast(address - (_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY.SIZEOF * count));
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer subOffset(long offset) {
		return _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer.cast(address - offset);
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer untag(long mask) {
		return _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer.cast(address & ~mask);
	}

	public _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICYPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY.SIZEOF;
	}

	// Implementation methods

	// U32:1 EnableControlFlowGuard
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EnableControlFlowGuardOffset_", declaredType="U32:1")
	public UDATA EnableControlFlowGuard() throws CorruptDataException {
		return getU32Bitfield(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableControlFlowGuard_s_, _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableControlFlowGuard_b_);
	}

	// U32:1 EnableExportSuppression
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EnableExportSuppressionOffset_", declaredType="U32:1")
	public UDATA EnableExportSuppression() throws CorruptDataException {
		return getU32Bitfield(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableExportSuppression_s_, _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableExportSuppression_b_);
	}

	// U32:1 EnableXfg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EnableXfgOffset_", declaredType="U32:1")
	public UDATA EnableXfg() throws CorruptDataException {
		return getU32Bitfield(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableXfg_s_, _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableXfg_b_);
	}

	// U32:1 EnableXfgAuditMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EnableXfgAuditModeOffset_", declaredType="U32:1")
	public UDATA EnableXfgAuditMode() throws CorruptDataException {
		return getU32Bitfield(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableXfgAuditMode_s_, _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._EnableXfgAuditMode_b_);
	}

	// U32 Flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FlagsOffset_", declaredType="U32")
	public UDATA Flags() throws CorruptDataException {
		return new U32(getIntAtOffset(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._FlagsOffset_));
	}

	// U32 Flags
	public UDATAPointer FlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._FlagsOffset_));
	}

	// U32:27 ReservedFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedFlagsOffset_", declaredType="U32:27")
	public UDATA ReservedFlags() throws CorruptDataException {
		return getU32Bitfield(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._ReservedFlags_s_, _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._ReservedFlags_b_);
	}

	// U32:1 StrictMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StrictModeOffset_", declaredType="U32:1")
	public UDATA StrictMode() throws CorruptDataException {
		return getU32Bitfield(_PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._StrictMode_s_, _PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY._StrictMode_b_);
	}

}
