/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _STARTUPINFOWPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _STARTUPINFOWPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_STARTUPINFOW.class)
public class _STARTUPINFOWPointer extends StructurePointer {

	// NULL
	public static final _STARTUPINFOWPointer NULL = new _STARTUPINFOWPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _STARTUPINFOWPointer(long address) {
		super(address);
	}

	public static _STARTUPINFOWPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _STARTUPINFOWPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _STARTUPINFOWPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _STARTUPINFOWPointer(address);
	}

	public _STARTUPINFOWPointer add(long count) {
		return _STARTUPINFOWPointer.cast(address + (_STARTUPINFOW.SIZEOF * count));
	}

	public _STARTUPINFOWPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _STARTUPINFOWPointer addOffset(long offset) {
		return _STARTUPINFOWPointer.cast(address + offset);
	}

	public _STARTUPINFOWPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _STARTUPINFOWPointer sub(long count) {
		return _STARTUPINFOWPointer.cast(address - (_STARTUPINFOW.SIZEOF * count));
	}

	public _STARTUPINFOWPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _STARTUPINFOWPointer subOffset(long offset) {
		return _STARTUPINFOWPointer.cast(address - offset);
	}

	public _STARTUPINFOWPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _STARTUPINFOWPointer untag(long mask) {
		return _STARTUPINFOWPointer.cast(address & ~mask);
	}

	public _STARTUPINFOWPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _STARTUPINFOW.SIZEOF;
	}

	// Implementation methods

	// U32 cb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbOffset_", declaredType="U32")
	public UDATA cb() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._cbOffset_));
	}

	// U32 cb
	public UDATAPointer cbEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._cbOffset_));
	}

	// U16 cbReserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbReserved2Offset_", declaredType="U16")
	public U16 cbReserved2() throws CorruptDataException {
		return new U16(getShortAtOffset(_STARTUPINFOW._cbReserved2Offset_));
	}

	// U16 cbReserved2
	public U16Pointer cbReserved2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_STARTUPINFOW._cbReserved2Offset_));
	}

	// U32 dwFillAttribute
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFillAttributeOffset_", declaredType="U32")
	public UDATA dwFillAttribute() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwFillAttributeOffset_));
	}

	// U32 dwFillAttribute
	public UDATAPointer dwFillAttributeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwFillAttributeOffset_));
	}

	// U32 dwFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwFlagsOffset_", declaredType="U32")
	public UDATA dwFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwFlagsOffset_));
	}

	// U32 dwFlags
	public UDATAPointer dwFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwFlagsOffset_));
	}

	// U32 dwX
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwXOffset_", declaredType="U32")
	public UDATA dwX() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwXOffset_));
	}

	// U32 dwX
	public UDATAPointer dwXEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwXOffset_));
	}

	// U32 dwXCountChars
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwXCountCharsOffset_", declaredType="U32")
	public UDATA dwXCountChars() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwXCountCharsOffset_));
	}

	// U32 dwXCountChars
	public UDATAPointer dwXCountCharsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwXCountCharsOffset_));
	}

	// U32 dwXSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwXSizeOffset_", declaredType="U32")
	public UDATA dwXSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwXSizeOffset_));
	}

	// U32 dwXSize
	public UDATAPointer dwXSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwXSizeOffset_));
	}

	// U32 dwY
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwYOffset_", declaredType="U32")
	public UDATA dwY() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwYOffset_));
	}

	// U32 dwY
	public UDATAPointer dwYEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwYOffset_));
	}

	// U32 dwYCountChars
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwYCountCharsOffset_", declaredType="U32")
	public UDATA dwYCountChars() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwYCountCharsOffset_));
	}

	// U32 dwYCountChars
	public UDATAPointer dwYCountCharsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwYCountCharsOffset_));
	}

	// U32 dwYSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwYSizeOffset_", declaredType="U32")
	public UDATA dwYSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_STARTUPINFOW._dwYSizeOffset_));
	}

	// U32 dwYSize
	public UDATAPointer dwYSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_STARTUPINFOW._dwYSizeOffset_));
	}

	// void* hStdError
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hStdErrorOffset_", declaredType="void*")
	public VoidPointer hStdError() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_STARTUPINFOW._hStdErrorOffset_));
	}

	// void* hStdError
	public PointerPointer hStdErrorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._hStdErrorOffset_));
	}

	// void* hStdInput
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hStdInputOffset_", declaredType="void*")
	public VoidPointer hStdInput() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_STARTUPINFOW._hStdInputOffset_));
	}

	// void* hStdInput
	public PointerPointer hStdInputEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._hStdInputOffset_));
	}

	// void* hStdOutput
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hStdOutputOffset_", declaredType="void*")
	public VoidPointer hStdOutput() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_STARTUPINFOW._hStdOutputOffset_));
	}

	// void* hStdOutput
	public PointerPointer hStdOutputEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._hStdOutputOffset_));
	}

	// U16* lpDesktop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpDesktopOffset_", declaredType="U16*")
	public U16Pointer lpDesktop() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(_STARTUPINFOW._lpDesktopOffset_));
	}

	// U16* lpDesktop
	public PointerPointer lpDesktopEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._lpDesktopOffset_));
	}

	// U16* lpReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpReservedOffset_", declaredType="U16*")
	public U16Pointer lpReserved() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(_STARTUPINFOW._lpReservedOffset_));
	}

	// U16* lpReserved
	public PointerPointer lpReservedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._lpReservedOffset_));
	}

	// U8* lpReserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpReserved2Offset_", declaredType="U8*")
	public U8Pointer lpReserved2() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_STARTUPINFOW._lpReserved2Offset_));
	}

	// U8* lpReserved2
	public PointerPointer lpReserved2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._lpReserved2Offset_));
	}

	// U16* lpTitle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpTitleOffset_", declaredType="U16*")
	public U16Pointer lpTitle() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(_STARTUPINFOW._lpTitleOffset_));
	}

	// U16* lpTitle
	public PointerPointer lpTitleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_STARTUPINFOW._lpTitleOffset_));
	}

	// U16 wShowWindow
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wShowWindowOffset_", declaredType="U16")
	public U16 wShowWindow() throws CorruptDataException {
		return new U16(getShortAtOffset(_STARTUPINFOW._wShowWindowOffset_));
	}

	// U16 wShowWindow
	public U16Pointer wShowWindowEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_STARTUPINFOW._wShowWindowOffset_));
	}

}
