/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _SYMBOL_INFOPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _SYMBOL_INFOPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_SYMBOL_INFO.class)
public class _SYMBOL_INFOPointer extends StructurePointer {

	// NULL
	public static final _SYMBOL_INFOPointer NULL = new _SYMBOL_INFOPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _SYMBOL_INFOPointer(long address) {
		super(address);
	}

	public static _SYMBOL_INFOPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _SYMBOL_INFOPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _SYMBOL_INFOPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _SYMBOL_INFOPointer(address);
	}

	public _SYMBOL_INFOPointer add(long count) {
		return _SYMBOL_INFOPointer.cast(address + (_SYMBOL_INFO.SIZEOF * count));
	}

	public _SYMBOL_INFOPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _SYMBOL_INFOPointer addOffset(long offset) {
		return _SYMBOL_INFOPointer.cast(address + offset);
	}

	public _SYMBOL_INFOPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _SYMBOL_INFOPointer sub(long count) {
		return _SYMBOL_INFOPointer.cast(address - (_SYMBOL_INFO.SIZEOF * count));
	}

	public _SYMBOL_INFOPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _SYMBOL_INFOPointer subOffset(long offset) {
		return _SYMBOL_INFOPointer.cast(address - offset);
	}

	public _SYMBOL_INFOPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _SYMBOL_INFOPointer untag(long mask) {
		return _SYMBOL_INFOPointer.cast(address & ~mask);
	}

	public _SYMBOL_INFOPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _SYMBOL_INFO.SIZEOF;
	}

	// Implementation methods

	// U64 Address
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddressOffset_", declaredType="U64")
	public UDATA Address() throws CorruptDataException {
		return new U64(getLongAtOffset(_SYMBOL_INFO._AddressOffset_));
	}

	// U64 Address
	public UDATAPointer AddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._AddressOffset_));
	}

	// U32 Flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FlagsOffset_", declaredType="U32")
	public UDATA Flags() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._FlagsOffset_));
	}

	// U32 Flags
	public UDATAPointer FlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._FlagsOffset_));
	}

	// U32 Index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IndexOffset_", declaredType="U32")
	public UDATA Index() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._IndexOffset_));
	}

	// U32 Index
	public UDATAPointer IndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._IndexOffset_));
	}

	// U32 MaxNameLen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MaxNameLenOffset_", declaredType="U32")
	public UDATA MaxNameLen() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._MaxNameLenOffset_));
	}

	// U32 MaxNameLen
	public UDATAPointer MaxNameLenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._MaxNameLenOffset_));
	}

	// U64 ModBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ModBaseOffset_", declaredType="U64")
	public UDATA ModBase() throws CorruptDataException {
		return new U64(getLongAtOffset(_SYMBOL_INFO._ModBaseOffset_));
	}

	// U64 ModBase
	public UDATAPointer ModBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._ModBaseOffset_));
	}

	// U8[] Name
	public U8Pointer NameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_SYMBOL_INFO._NameOffset_));
	}

	// U32 NameLen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NameLenOffset_", declaredType="U32")
	public UDATA NameLen() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._NameLenOffset_));
	}

	// U32 NameLen
	public UDATAPointer NameLenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._NameLenOffset_));
	}

	// U32 Register
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RegisterOffset_", declaredType="U32")
	public UDATA Register() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._RegisterOffset_));
	}

	// U32 Register
	public UDATAPointer RegisterEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._RegisterOffset_));
	}

	// U64[] Reserved
	public UDATAPointer ReservedEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_SYMBOL_INFO._ReservedOffset_));
	}

	// U32 Scope
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ScopeOffset_", declaredType="U32")
	public UDATA Scope() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._ScopeOffset_));
	}

	// U32 Scope
	public UDATAPointer ScopeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._ScopeOffset_));
	}

	// U32 Size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOffset_", declaredType="U32")
	public UDATA Size() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._SizeOffset_));
	}

	// U32 Size
	public UDATAPointer SizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._SizeOffset_));
	}

	// U32 SizeOfStruct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfStructOffset_", declaredType="U32")
	public UDATA SizeOfStruct() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._SizeOfStructOffset_));
	}

	// U32 SizeOfStruct
	public UDATAPointer SizeOfStructEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._SizeOfStructOffset_));
	}

	// U32 Tag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TagOffset_", declaredType="U32")
	public UDATA Tag() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._TagOffset_));
	}

	// U32 Tag
	public UDATAPointer TagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._TagOffset_));
	}

	// U32 TypeIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TypeIndexOffset_", declaredType="U32")
	public UDATA TypeIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYMBOL_INFO._TypeIndexOffset_));
	}

	// U32 TypeIndex
	public UDATAPointer TypeIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._TypeIndexOffset_));
	}

	// U64 Value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ValueOffset_", declaredType="U64")
	public UDATA Value() throws CorruptDataException {
		return new U64(getLongAtOffset(_SYMBOL_INFO._ValueOffset_));
	}

	// U64 Value
	public UDATAPointer ValueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYMBOL_INFO._ValueOffset_));
	}

}
