/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: cudaChannelFormatDescPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the cudaChannelFormatDescPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=cudaChannelFormatDesc.class)
public class cudaChannelFormatDescPointer extends StructurePointer {

	// NULL
	public static final cudaChannelFormatDescPointer NULL = new cudaChannelFormatDescPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected cudaChannelFormatDescPointer(long address) {
		super(address);
	}

	public static cudaChannelFormatDescPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static cudaChannelFormatDescPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static cudaChannelFormatDescPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new cudaChannelFormatDescPointer(address);
	}

	public cudaChannelFormatDescPointer add(long count) {
		return cudaChannelFormatDescPointer.cast(address + (cudaChannelFormatDesc.SIZEOF * count));
	}

	public cudaChannelFormatDescPointer add(Scalar count) {
		return add(count.longValue());
	}

	public cudaChannelFormatDescPointer addOffset(long offset) {
		return cudaChannelFormatDescPointer.cast(address + offset);
	}

	public cudaChannelFormatDescPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public cudaChannelFormatDescPointer sub(long count) {
		return cudaChannelFormatDescPointer.cast(address - (cudaChannelFormatDesc.SIZEOF * count));
	}

	public cudaChannelFormatDescPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public cudaChannelFormatDescPointer subOffset(long offset) {
		return cudaChannelFormatDescPointer.cast(address - offset);
	}

	public cudaChannelFormatDescPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public cudaChannelFormatDescPointer untag(long mask) {
		return cudaChannelFormatDescPointer.cast(address & ~mask);
	}

	public cudaChannelFormatDescPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return cudaChannelFormatDesc.SIZEOF;
	}

	// Implementation methods

	// cudaChannelFormatKind f
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fOffset_", declaredType="cudaChannelFormatKind")
	public long f() throws CorruptDataException {
		if (cudaChannelFormatKind.SIZEOF == 1) {
			return getByteAtOffset(cudaChannelFormatDesc._fOffset_);
		} else if (cudaChannelFormatKind.SIZEOF == 2) {
			return getShortAtOffset(cudaChannelFormatDesc._fOffset_);
		} else if (cudaChannelFormatKind.SIZEOF == 4) {
			return getIntAtOffset(cudaChannelFormatDesc._fOffset_);
		} else if (cudaChannelFormatKind.SIZEOF == 8) {
			return getLongAtOffset(cudaChannelFormatDesc._fOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// cudaChannelFormatKind f
	public EnumPointer fEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(cudaChannelFormatDesc._fOffset_), cudaChannelFormatKind.class);
	}

	// I32 w
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wOffset_", declaredType="I32")
	public IDATA w() throws CorruptDataException {
		return new I32(getIntAtOffset(cudaChannelFormatDesc._wOffset_));
	}

	// I32 w
	public IDATAPointer wEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(cudaChannelFormatDesc._wOffset_));
	}

	// I32 x
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xOffset_", declaredType="I32")
	public IDATA x() throws CorruptDataException {
		return new I32(getIntAtOffset(cudaChannelFormatDesc._xOffset_));
	}

	// I32 x
	public IDATAPointer xEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(cudaChannelFormatDesc._xOffset_));
	}

	// I32 y
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_yOffset_", declaredType="I32")
	public IDATA y() throws CorruptDataException {
		return new I32(getIntAtOffset(cudaChannelFormatDesc._yOffset_));
	}

	// I32 y
	public IDATAPointer yEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(cudaChannelFormatDesc._yOffset_));
	}

	// I32 z
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zOffset_", declaredType="I32")
	public IDATA z() throws CorruptDataException {
		return new I32(getIntAtOffset(cudaChannelFormatDesc._zOffset_));
	}

	// I32 z
	public IDATAPointer zEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(cudaChannelFormatDesc._zOffset_));
	}

}
