/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: jvmtiEventCallbacksPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the jvmtiEventCallbacksPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=jvmtiEventCallbacks.class)
public class jvmtiEventCallbacksPointer extends StructurePointer {

	// NULL
	public static final jvmtiEventCallbacksPointer NULL = new jvmtiEventCallbacksPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected jvmtiEventCallbacksPointer(long address) {
		super(address);
	}

	public static jvmtiEventCallbacksPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static jvmtiEventCallbacksPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static jvmtiEventCallbacksPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new jvmtiEventCallbacksPointer(address);
	}

	public jvmtiEventCallbacksPointer add(long count) {
		return jvmtiEventCallbacksPointer.cast(address + (jvmtiEventCallbacks.SIZEOF * count));
	}

	public jvmtiEventCallbacksPointer add(Scalar count) {
		return add(count.longValue());
	}

	public jvmtiEventCallbacksPointer addOffset(long offset) {
		return jvmtiEventCallbacksPointer.cast(address + offset);
	}

	public jvmtiEventCallbacksPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public jvmtiEventCallbacksPointer sub(long count) {
		return jvmtiEventCallbacksPointer.cast(address - (jvmtiEventCallbacks.SIZEOF * count));
	}

	public jvmtiEventCallbacksPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public jvmtiEventCallbacksPointer subOffset(long offset) {
		return jvmtiEventCallbacksPointer.cast(address - offset);
	}

	public jvmtiEventCallbacksPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public jvmtiEventCallbacksPointer untag(long mask) {
		return jvmtiEventCallbacksPointer.cast(address & ~mask);
	}

	public jvmtiEventCallbacksPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return jvmtiEventCallbacks.SIZEOF;
	}

	// Implementation methods

	// void* Breakpoint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BreakpointOffset_", declaredType="void*")
	public VoidPointer Breakpoint() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._BreakpointOffset_));
	}

	// void* Breakpoint
	public PointerPointer BreakpointEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._BreakpointOffset_));
	}

	// void* ClassFileLoadHook
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ClassFileLoadHookOffset_", declaredType="void*")
	public VoidPointer ClassFileLoadHook() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ClassFileLoadHookOffset_));
	}

	// void* ClassFileLoadHook
	public PointerPointer ClassFileLoadHookEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ClassFileLoadHookOffset_));
	}

	// void* ClassLoad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ClassLoadOffset_", declaredType="void*")
	public VoidPointer ClassLoad() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ClassLoadOffset_));
	}

	// void* ClassLoad
	public PointerPointer ClassLoadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ClassLoadOffset_));
	}

	// void* ClassPrepare
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ClassPrepareOffset_", declaredType="void*")
	public VoidPointer ClassPrepare() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ClassPrepareOffset_));
	}

	// void* ClassPrepare
	public PointerPointer ClassPrepareEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ClassPrepareOffset_));
	}

	// void* CompiledMethodLoad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CompiledMethodLoadOffset_", declaredType="void*")
	public VoidPointer CompiledMethodLoad() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._CompiledMethodLoadOffset_));
	}

	// void* CompiledMethodLoad
	public PointerPointer CompiledMethodLoadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._CompiledMethodLoadOffset_));
	}

	// void* CompiledMethodUnload
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CompiledMethodUnloadOffset_", declaredType="void*")
	public VoidPointer CompiledMethodUnload() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._CompiledMethodUnloadOffset_));
	}

	// void* CompiledMethodUnload
	public PointerPointer CompiledMethodUnloadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._CompiledMethodUnloadOffset_));
	}

	// void* DataDumpRequest
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DataDumpRequestOffset_", declaredType="void*")
	public VoidPointer DataDumpRequest() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._DataDumpRequestOffset_));
	}

	// void* DataDumpRequest
	public PointerPointer DataDumpRequestEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._DataDumpRequestOffset_));
	}

	// void* DynamicCodeGenerated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DynamicCodeGeneratedOffset_", declaredType="void*")
	public VoidPointer DynamicCodeGenerated() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._DynamicCodeGeneratedOffset_));
	}

	// void* DynamicCodeGenerated
	public PointerPointer DynamicCodeGeneratedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._DynamicCodeGeneratedOffset_));
	}

	// void* Exception
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionOffset_", declaredType="void*")
	public VoidPointer Exception() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ExceptionOffset_));
	}

	// void* Exception
	public PointerPointer ExceptionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ExceptionOffset_));
	}

	// void* ExceptionCatch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionCatchOffset_", declaredType="void*")
	public VoidPointer ExceptionCatch() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ExceptionCatchOffset_));
	}

	// void* ExceptionCatch
	public PointerPointer ExceptionCatchEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ExceptionCatchOffset_));
	}

	// void* FieldAccess
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FieldAccessOffset_", declaredType="void*")
	public VoidPointer FieldAccess() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._FieldAccessOffset_));
	}

	// void* FieldAccess
	public PointerPointer FieldAccessEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._FieldAccessOffset_));
	}

	// void* FieldModification
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FieldModificationOffset_", declaredType="void*")
	public VoidPointer FieldModification() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._FieldModificationOffset_));
	}

	// void* FieldModification
	public PointerPointer FieldModificationEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._FieldModificationOffset_));
	}

	// void* FramePop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FramePopOffset_", declaredType="void*")
	public VoidPointer FramePop() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._FramePopOffset_));
	}

	// void* FramePop
	public PointerPointer FramePopEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._FramePopOffset_));
	}

	// void* GarbageCollectionFinish
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GarbageCollectionFinishOffset_", declaredType="void*")
	public VoidPointer GarbageCollectionFinish() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._GarbageCollectionFinishOffset_));
	}

	// void* GarbageCollectionFinish
	public PointerPointer GarbageCollectionFinishEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._GarbageCollectionFinishOffset_));
	}

	// void* GarbageCollectionStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GarbageCollectionStartOffset_", declaredType="void*")
	public VoidPointer GarbageCollectionStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._GarbageCollectionStartOffset_));
	}

	// void* GarbageCollectionStart
	public PointerPointer GarbageCollectionStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._GarbageCollectionStartOffset_));
	}

	// void* MethodEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MethodEntryOffset_", declaredType="void*")
	public VoidPointer MethodEntry() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._MethodEntryOffset_));
	}

	// void* MethodEntry
	public PointerPointer MethodEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._MethodEntryOffset_));
	}

	// void* MethodExit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MethodExitOffset_", declaredType="void*")
	public VoidPointer MethodExit() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._MethodExitOffset_));
	}

	// void* MethodExit
	public PointerPointer MethodExitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._MethodExitOffset_));
	}

	// void* MonitorContendedEnter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MonitorContendedEnterOffset_", declaredType="void*")
	public VoidPointer MonitorContendedEnter() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._MonitorContendedEnterOffset_));
	}

	// void* MonitorContendedEnter
	public PointerPointer MonitorContendedEnterEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._MonitorContendedEnterOffset_));
	}

	// void* MonitorContendedEntered
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MonitorContendedEnteredOffset_", declaredType="void*")
	public VoidPointer MonitorContendedEntered() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._MonitorContendedEnteredOffset_));
	}

	// void* MonitorContendedEntered
	public PointerPointer MonitorContendedEnteredEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._MonitorContendedEnteredOffset_));
	}

	// void* MonitorWait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MonitorWaitOffset_", declaredType="void*")
	public VoidPointer MonitorWait() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._MonitorWaitOffset_));
	}

	// void* MonitorWait
	public PointerPointer MonitorWaitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._MonitorWaitOffset_));
	}

	// void* MonitorWaited
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MonitorWaitedOffset_", declaredType="void*")
	public VoidPointer MonitorWaited() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._MonitorWaitedOffset_));
	}

	// void* MonitorWaited
	public PointerPointer MonitorWaitedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._MonitorWaitedOffset_));
	}

	// void* NativeMethodBind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NativeMethodBindOffset_", declaredType="void*")
	public VoidPointer NativeMethodBind() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._NativeMethodBindOffset_));
	}

	// void* NativeMethodBind
	public PointerPointer NativeMethodBindEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._NativeMethodBindOffset_));
	}

	// void* ObjectFree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ObjectFreeOffset_", declaredType="void*")
	public VoidPointer ObjectFree() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ObjectFreeOffset_));
	}

	// void* ObjectFree
	public PointerPointer ObjectFreeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ObjectFreeOffset_));
	}

	// void* ResourceExhausted
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ResourceExhaustedOffset_", declaredType="void*")
	public VoidPointer ResourceExhausted() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ResourceExhaustedOffset_));
	}

	// void* ResourceExhausted
	public PointerPointer ResourceExhaustedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ResourceExhaustedOffset_));
	}

	// void* SampledObjectAlloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SampledObjectAllocOffset_", declaredType="void*")
	public VoidPointer SampledObjectAlloc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._SampledObjectAllocOffset_));
	}

	// void* SampledObjectAlloc
	public PointerPointer SampledObjectAllocEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._SampledObjectAllocOffset_));
	}

	// void* SingleStep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SingleStepOffset_", declaredType="void*")
	public VoidPointer SingleStep() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._SingleStepOffset_));
	}

	// void* SingleStep
	public PointerPointer SingleStepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._SingleStepOffset_));
	}

	// void* ThreadEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThreadEndOffset_", declaredType="void*")
	public VoidPointer ThreadEnd() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ThreadEndOffset_));
	}

	// void* ThreadEnd
	public PointerPointer ThreadEndEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ThreadEndOffset_));
	}

	// void* ThreadStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThreadStartOffset_", declaredType="void*")
	public VoidPointer ThreadStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._ThreadStartOffset_));
	}

	// void* ThreadStart
	public PointerPointer ThreadStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._ThreadStartOffset_));
	}

	// void* VMDeath
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VMDeathOffset_", declaredType="void*")
	public VoidPointer VMDeath() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._VMDeathOffset_));
	}

	// void* VMDeath
	public PointerPointer VMDeathEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._VMDeathOffset_));
	}

	// void* VMInit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VMInitOffset_", declaredType="void*")
	public VoidPointer VMInit() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._VMInitOffset_));
	}

	// void* VMInit
	public PointerPointer VMInitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._VMInitOffset_));
	}

	// void* VMObjectAlloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VMObjectAllocOffset_", declaredType="void*")
	public VoidPointer VMObjectAlloc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._VMObjectAllocOffset_));
	}

	// void* VMObjectAlloc
	public PointerPointer VMObjectAllocEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._VMObjectAllocOffset_));
	}

	// void* VMStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VMStartOffset_", declaredType="void*")
	public VoidPointer VMStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._VMStartOffset_));
	}

	// void* VMStart
	public PointerPointer VMStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._VMStartOffset_));
	}

	// void* VirtualThreadEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VirtualThreadEndOffset_", declaredType="void*")
	public VoidPointer VirtualThreadEnd() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._VirtualThreadEndOffset_));
	}

	// void* VirtualThreadEnd
	public PointerPointer VirtualThreadEndEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._VirtualThreadEndOffset_));
	}

	// void* VirtualThreadStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VirtualThreadStartOffset_", declaredType="void*")
	public VoidPointer VirtualThreadStart() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._VirtualThreadStartOffset_));
	}

	// void* VirtualThreadStart
	public PointerPointer VirtualThreadStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._VirtualThreadStartOffset_));
	}

	// void* reserved72
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved72Offset_", declaredType="void*")
	public VoidPointer reserved72() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._reserved72Offset_));
	}

	// void* reserved72
	public PointerPointer reserved72EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._reserved72Offset_));
	}

	// void* reserved77
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved77Offset_", declaredType="void*")
	public VoidPointer reserved77() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._reserved77Offset_));
	}

	// void* reserved77
	public PointerPointer reserved77EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._reserved77Offset_));
	}

	// void* reserved78
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved78Offset_", declaredType="void*")
	public VoidPointer reserved78() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._reserved78Offset_));
	}

	// void* reserved78
	public PointerPointer reserved78EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._reserved78Offset_));
	}

	// void* reserved79
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved79Offset_", declaredType="void*")
	public VoidPointer reserved79() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._reserved79Offset_));
	}

	// void* reserved79
	public PointerPointer reserved79EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._reserved79Offset_));
	}

	// void* reserved85
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved85Offset_", declaredType="void*")
	public VoidPointer reserved85() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiEventCallbacks._reserved85Offset_));
	}

	// void* reserved85
	public PointerPointer reserved85EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiEventCallbacks._reserved85Offset_));
	}

}
