/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagTYPEATTRPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagTYPEATTRPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagTYPEATTR.class)
public class tagTYPEATTRPointer extends StructurePointer {

	// NULL
	public static final tagTYPEATTRPointer NULL = new tagTYPEATTRPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagTYPEATTRPointer(long address) {
		super(address);
	}

	public static tagTYPEATTRPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagTYPEATTRPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagTYPEATTRPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagTYPEATTRPointer(address);
	}

	public tagTYPEATTRPointer add(long count) {
		return tagTYPEATTRPointer.cast(address + (tagTYPEATTR.SIZEOF * count));
	}

	public tagTYPEATTRPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagTYPEATTRPointer addOffset(long offset) {
		return tagTYPEATTRPointer.cast(address + offset);
	}

	public tagTYPEATTRPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagTYPEATTRPointer sub(long count) {
		return tagTYPEATTRPointer.cast(address - (tagTYPEATTR.SIZEOF * count));
	}

	public tagTYPEATTRPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagTYPEATTRPointer subOffset(long offset) {
		return tagTYPEATTRPointer.cast(address - offset);
	}

	public tagTYPEATTRPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagTYPEATTRPointer untag(long mask) {
		return tagTYPEATTRPointer.cast(address & ~mask);
	}

	public tagTYPEATTRPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagTYPEATTR.SIZEOF;
	}

	// Implementation methods

	// U16 cFuncs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cFuncsOffset_", declaredType="U16")
	public U16 cFuncs() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._cFuncsOffset_));
	}

	// U16 cFuncs
	public U16Pointer cFuncsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._cFuncsOffset_));
	}

	// U16 cImplTypes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cImplTypesOffset_", declaredType="U16")
	public U16 cImplTypes() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._cImplTypesOffset_));
	}

	// U16 cImplTypes
	public U16Pointer cImplTypesEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._cImplTypesOffset_));
	}

	// U16 cVars
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cVarsOffset_", declaredType="U16")
	public U16 cVars() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._cVarsOffset_));
	}

	// U16 cVars
	public U16Pointer cVarsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._cVarsOffset_));
	}

	// U16 cbAlignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbAlignmentOffset_", declaredType="U16")
	public U16 cbAlignment() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._cbAlignmentOffset_));
	}

	// U16 cbAlignment
	public U16Pointer cbAlignmentEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._cbAlignmentOffset_));
	}

	// U32 cbSizeInstance
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbSizeInstanceOffset_", declaredType="U32")
	public UDATA cbSizeInstance() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTYPEATTR._cbSizeInstanceOffset_));
	}

	// U32 cbSizeInstance
	public UDATAPointer cbSizeInstanceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTYPEATTR._cbSizeInstanceOffset_));
	}

	// U16 cbSizeVft
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbSizeVftOffset_", declaredType="U16")
	public U16 cbSizeVft() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._cbSizeVftOffset_));
	}

	// U16 cbSizeVft
	public U16Pointer cbSizeVftEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._cbSizeVftOffset_));
	}

	// U32 dwReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwReservedOffset_", declaredType="U32")
	public UDATA dwReserved() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTYPEATTR._dwReservedOffset_));
	}

	// U32 dwReserved
	public UDATAPointer dwReservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTYPEATTR._dwReservedOffset_));
	}

	// _GUID guid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_guidOffset_", declaredType="_GUID")
	public _GUIDPointer guid() throws CorruptDataException {
		return _GUIDPointer.cast(nonNullFieldEA(tagTYPEATTR._guidOffset_));
	}

	// _GUID guid
	public PointerPointer guidEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagTYPEATTR._guidOffset_));
	}

	// tagIDLDESC idldescType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idldescTypeOffset_", declaredType="tagIDLDESC")
	public tagIDLDESCPointer idldescType() throws CorruptDataException {
		return tagIDLDESCPointer.cast(nonNullFieldEA(tagTYPEATTR._idldescTypeOffset_));
	}

	// tagIDLDESC idldescType
	public PointerPointer idldescTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagTYPEATTR._idldescTypeOffset_));
	}

	// U32 lcid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lcidOffset_", declaredType="U32")
	public UDATA lcid() throws CorruptDataException {
		return new U32(getIntAtOffset(tagTYPEATTR._lcidOffset_));
	}

	// U32 lcid
	public UDATAPointer lcidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagTYPEATTR._lcidOffset_));
	}

	// U16* lpstrSchema
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpstrSchemaOffset_", declaredType="U16*")
	public U16Pointer lpstrSchema() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagTYPEATTR._lpstrSchemaOffset_));
	}

	// U16* lpstrSchema
	public PointerPointer lpstrSchemaEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagTYPEATTR._lpstrSchemaOffset_));
	}

	// I32 memidConstructor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memidConstructorOffset_", declaredType="I32")
	public IDATA memidConstructor() throws CorruptDataException {
		return new I32(getIntAtOffset(tagTYPEATTR._memidConstructorOffset_));
	}

	// I32 memidConstructor
	public IDATAPointer memidConstructorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagTYPEATTR._memidConstructorOffset_));
	}

	// I32 memidDestructor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memidDestructorOffset_", declaredType="I32")
	public IDATA memidDestructor() throws CorruptDataException {
		return new I32(getIntAtOffset(tagTYPEATTR._memidDestructorOffset_));
	}

	// I32 memidDestructor
	public IDATAPointer memidDestructorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagTYPEATTR._memidDestructorOffset_));
	}

	// tagTYPEDESC tdescAlias
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tdescAliasOffset_", declaredType="tagTYPEDESC")
	public tagTYPEDESCPointer tdescAlias() throws CorruptDataException {
		return tagTYPEDESCPointer.cast(nonNullFieldEA(tagTYPEATTR._tdescAliasOffset_));
	}

	// tagTYPEDESC tdescAlias
	public PointerPointer tdescAliasEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagTYPEATTR._tdescAliasOffset_));
	}

	// tagTYPEKIND typekind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typekindOffset_", declaredType="tagTYPEKIND")
	public long typekind() throws CorruptDataException {
		if (tagTYPEKIND.SIZEOF == 1) {
			return getByteAtOffset(tagTYPEATTR._typekindOffset_);
		} else if (tagTYPEKIND.SIZEOF == 2) {
			return getShortAtOffset(tagTYPEATTR._typekindOffset_);
		} else if (tagTYPEKIND.SIZEOF == 4) {
			return getIntAtOffset(tagTYPEATTR._typekindOffset_);
		} else if (tagTYPEKIND.SIZEOF == 8) {
			return getLongAtOffset(tagTYPEATTR._typekindOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// tagTYPEKIND typekind
	public EnumPointer typekindEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(tagTYPEATTR._typekindOffset_), tagTYPEKIND.class);
	}

	// U16 wMajorVerNum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wMajorVerNumOffset_", declaredType="U16")
	public U16 wMajorVerNum() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._wMajorVerNumOffset_));
	}

	// U16 wMajorVerNum
	public U16Pointer wMajorVerNumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._wMajorVerNumOffset_));
	}

	// U16 wMinorVerNum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wMinorVerNumOffset_", declaredType="U16")
	public U16 wMinorVerNum() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._wMinorVerNumOffset_));
	}

	// U16 wMinorVerNum
	public U16Pointer wMinorVerNumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._wMinorVerNumOffset_));
	}

	// U16 wTypeFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wTypeFlagsOffset_", declaredType="U16")
	public U16 wTypeFlags() throws CorruptDataException {
		return new U16(getShortAtOffset(tagTYPEATTR._wTypeFlagsOffset_));
	}

	// U16 wTypeFlags
	public U16Pointer wTypeFlagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagTYPEATTR._wTypeFlagsOffset_));
	}

}
