/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagVARIANTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagVARIANTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagVARIANT.class)
public class tagVARIANTPointer extends StructurePointer {

	// NULL
	public static final tagVARIANTPointer NULL = new tagVARIANTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagVARIANTPointer(long address) {
		super(address);
	}

	public static tagVARIANTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagVARIANTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagVARIANTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagVARIANTPointer(address);
	}

	public tagVARIANTPointer add(long count) {
		return tagVARIANTPointer.cast(address + (tagVARIANT.SIZEOF * count));
	}

	public tagVARIANTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagVARIANTPointer addOffset(long offset) {
		return tagVARIANTPointer.cast(address + offset);
	}

	public tagVARIANTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagVARIANTPointer sub(long count) {
		return tagVARIANTPointer.cast(address - (tagVARIANT.SIZEOF * count));
	}

	public tagVARIANTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagVARIANTPointer subOffset(long offset) {
		return tagVARIANTPointer.cast(address - offset);
	}

	public tagVARIANTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagVARIANTPointer untag(long mask) {
		return tagVARIANTPointer.cast(address & ~mask);
	}

	public tagVARIANTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagVARIANT.SIZEOF;
	}

	// Implementation methods

	// I16 __OBSOLETE__VARIANT_BOOL
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___OBSOLETE__VARIANT_BOOLOffset_", declaredType="I16")
	public I16 __OBSOLETE__VARIANT_BOOL() throws CorruptDataException {
		return new I16(getShortAtOffset(tagVARIANT.___OBSOLETE__VARIANT_BOOLOffset_));
	}

	// I16 __OBSOLETE__VARIANT_BOOL
	public I16Pointer __OBSOLETE__VARIANT_BOOLEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagVARIANT.___OBSOLETE__VARIANT_BOOLOffset_));
	}

	// I16* __OBSOLETE__VARIANT_PBOOL
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___OBSOLETE__VARIANT_PBOOLOffset_", declaredType="I16*")
	public I16Pointer __OBSOLETE__VARIANT_PBOOL() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(tagVARIANT.___OBSOLETE__VARIANT_PBOOLOffset_));
	}

	// I16* __OBSOLETE__VARIANT_PBOOL
	public PointerPointer __OBSOLETE__VARIANT_PBOOLEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT.___OBSOLETE__VARIANT_PBOOLOffset_));
	}

	// U8 bVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bValOffset_", declaredType="U8")
	public U8 bVal() throws CorruptDataException {
		return new U8(getByteAtOffset(tagVARIANT._bValOffset_));
	}

	// U8 bVal
	public U8Pointer bValEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tagVARIANT._bValOffset_));
	}

	// I16 boolVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_boolValOffset_", declaredType="I16")
	public I16 boolVal() throws CorruptDataException {
		return new I16(getShortAtOffset(tagVARIANT._boolValOffset_));
	}

	// I16 boolVal
	public I16Pointer boolValEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagVARIANT._boolValOffset_));
	}

	// U16* bstrVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bstrValOffset_", declaredType="U16*")
	public U16Pointer bstrVal() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagVARIANT._bstrValOffset_));
	}

	// U16* bstrVal
	public PointerPointer bstrValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._bstrValOffset_));
	}

	// void* byref
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_byrefOffset_", declaredType="void*")
	public VoidPointer byref() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tagVARIANT._byrefOffset_));
	}

	// void* byref
	public PointerPointer byrefEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._byrefOffset_));
	}

	// U8 cVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cValOffset_", declaredType="U8")
	public U8 cVal() throws CorruptDataException {
		return new U8(getByteAtOffset(tagVARIANT._cValOffset_));
	}

	// U8 cVal
	public U8Pointer cValEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tagVARIANT._cValOffset_));
	}

	// tagCY cyVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cyValOffset_", declaredType="tagCY")
	public tagCYPointer cyVal() throws CorruptDataException {
		return tagCYPointer.cast(nonNullFieldEA(tagVARIANT._cyValOffset_));
	}

	// tagCY cyVal
	public PointerPointer cyValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._cyValOffset_));
	}

	// double date
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dateOffset_", declaredType="double")
	public double date() throws CorruptDataException {
		return getDoubleAtOffset(tagVARIANT._dateOffset_);
	}

	// double date
	public DoublePointer dateEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(tagVARIANT._dateOffset_));
	}

	// double dblVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dblValOffset_", declaredType="double")
	public double dblVal() throws CorruptDataException {
		return getDoubleAtOffset(tagVARIANT._dblValOffset_);
	}

	// double dblVal
	public DoublePointer dblValEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(tagVARIANT._dblValOffset_));
	}

	// tagDEC decVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decValOffset_", declaredType="tagDEC")
	public tagDECPointer decVal() throws CorruptDataException {
		return tagDECPointer.cast(nonNullFieldEA(tagVARIANT._decValOffset_));
	}

	// tagDEC decVal
	public PointerPointer decValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._decValOffset_));
	}

	// float fltVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fltValOffset_", declaredType="float")
	public float fltVal() throws CorruptDataException {
		return getFloatAtOffset(tagVARIANT._fltValOffset_);
	}

	// float fltVal
	public FloatPointer fltValEA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(tagVARIANT._fltValOffset_));
	}

	// I16 iVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iValOffset_", declaredType="I16")
	public I16 iVal() throws CorruptDataException {
		return new I16(getShortAtOffset(tagVARIANT._iValOffset_));
	}

	// I16 iVal
	public I16Pointer iValEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tagVARIANT._iValOffset_));
	}

	// I32 intVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intValOffset_", declaredType="I32")
	public IDATA intVal() throws CorruptDataException {
		return new I32(getIntAtOffset(tagVARIANT._intValOffset_));
	}

	// I32 intVal
	public IDATAPointer intValEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagVARIANT._intValOffset_));
	}

	// I32 lVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lValOffset_", declaredType="I32")
	public IDATA lVal() throws CorruptDataException {
		return new I32(getIntAtOffset(tagVARIANT._lValOffset_));
	}

	// I32 lVal
	public IDATAPointer lValEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagVARIANT._lValOffset_));
	}

	// I64 llVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_llValOffset_", declaredType="I64")
	public IDATA llVal() throws CorruptDataException {
		return new I64(getLongAtOffset(tagVARIANT._llValOffset_));
	}

	// I64 llVal
	public IDATAPointer llValEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagVARIANT._llValOffset_));
	}

	// IRecordInfo* pRecInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pRecInfoOffset_", declaredType="IRecordInfo*")
	public IRecordInfoPointer pRecInfo() throws CorruptDataException {
		return IRecordInfoPointer.cast(getPointerAtOffset(tagVARIANT._pRecInfoOffset_));
	}

	// IRecordInfo* pRecInfo
	public PointerPointer pRecInfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pRecInfoOffset_));
	}

	// tagSAFEARRAY* parray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_parrayOffset_", declaredType="tagSAFEARRAY*")
	public tagSAFEARRAYPointer parray() throws CorruptDataException {
		return tagSAFEARRAYPointer.cast(getPointerAtOffset(tagVARIANT._parrayOffset_));
	}

	// tagSAFEARRAY* parray
	public PointerPointer parrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._parrayOffset_));
	}

	// U8* pbVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pbValOffset_", declaredType="U8*")
	public U8Pointer pbVal() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(tagVARIANT._pbValOffset_));
	}

	// U8* pbVal
	public PointerPointer pbValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pbValOffset_));
	}

	// I16* pboolVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pboolValOffset_", declaredType="I16*")
	public I16Pointer pboolVal() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(tagVARIANT._pboolValOffset_));
	}

	// I16* pboolVal
	public PointerPointer pboolValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pboolValOffset_));
	}

	// void** pbstrVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pbstrValOffset_", declaredType="void**")
	public PointerPointer pbstrVal() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagVARIANT._pbstrValOffset_));
	}

	// void** pbstrVal
	public PointerPointer pbstrValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pbstrValOffset_));
	}

	// U8* pcVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcValOffset_", declaredType="U8*")
	public U8Pointer pcVal() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(tagVARIANT._pcValOffset_));
	}

	// U8* pcVal
	public PointerPointer pcValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pcValOffset_));
	}

	// tagCY* pcyVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcyValOffset_", declaredType="tagCY*")
	public tagCYPointer pcyVal() throws CorruptDataException {
		return tagCYPointer.cast(getPointerAtOffset(tagVARIANT._pcyValOffset_));
	}

	// tagCY* pcyVal
	public PointerPointer pcyValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pcyValOffset_));
	}

	// double* pdate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdateOffset_", declaredType="double*")
	public DoublePointer pdate() throws CorruptDataException {
		return DoublePointer.cast(getPointerAtOffset(tagVARIANT._pdateOffset_));
	}

	// double* pdate
	public PointerPointer pdateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pdateOffset_));
	}

	// double* pdblVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdblValOffset_", declaredType="double*")
	public DoublePointer pdblVal() throws CorruptDataException {
		return DoublePointer.cast(getPointerAtOffset(tagVARIANT._pdblValOffset_));
	}

	// double* pdblVal
	public PointerPointer pdblValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pdblValOffset_));
	}

	// tagDEC* pdecVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdecValOffset_", declaredType="tagDEC*")
	public tagDECPointer pdecVal() throws CorruptDataException {
		return tagDECPointer.cast(getPointerAtOffset(tagVARIANT._pdecValOffset_));
	}

	// tagDEC* pdecVal
	public PointerPointer pdecValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pdecValOffset_));
	}

	// IDispatch* pdispVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdispValOffset_", declaredType="IDispatch*")
	public IDispatchPointer pdispVal() throws CorruptDataException {
		return IDispatchPointer.cast(getPointerAtOffset(tagVARIANT._pdispValOffset_));
	}

	// IDispatch* pdispVal
	public PointerPointer pdispValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pdispValOffset_));
	}

	// float* pfltVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfltValOffset_", declaredType="float*")
	public FloatPointer pfltVal() throws CorruptDataException {
		return FloatPointer.cast(getPointerAtOffset(tagVARIANT._pfltValOffset_));
	}

	// float* pfltVal
	public PointerPointer pfltValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pfltValOffset_));
	}

	// I16* piVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_piValOffset_", declaredType="I16*")
	public I16Pointer piVal() throws CorruptDataException {
		return I16Pointer.cast(getPointerAtOffset(tagVARIANT._piValOffset_));
	}

	// I16* piVal
	public PointerPointer piValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._piValOffset_));
	}

	// I32* pintVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pintValOffset_", declaredType="I32*")
	public IDATAPointer pintVal() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagVARIANT._pintValOffset_));
	}

	// I32* pintVal
	public PointerPointer pintValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pintValOffset_));
	}

	// I32* plVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_plValOffset_", declaredType="I32*")
	public IDATAPointer plVal() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagVARIANT._plValOffset_));
	}

	// I32* plVal
	public PointerPointer plValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._plValOffset_));
	}

	// I64* pllVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pllValOffset_", declaredType="I64*")
	public IDATAPointer pllVal() throws CorruptDataException {
		return I64Pointer.cast(getPointerAtOffset(tagVARIANT._pllValOffset_));
	}

	// I64* pllVal
	public PointerPointer pllValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pllValOffset_));
	}

	// void** pparray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pparrayOffset_", declaredType="void**")
	public PointerPointer pparray() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagVARIANT._pparrayOffset_));
	}

	// void** pparray
	public PointerPointer pparrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pparrayOffset_));
	}

	// void** ppdispVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ppdispValOffset_", declaredType="void**")
	public PointerPointer ppdispVal() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagVARIANT._ppdispValOffset_));
	}

	// void** ppdispVal
	public PointerPointer ppdispValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._ppdispValOffset_));
	}

	// void** ppunkVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ppunkValOffset_", declaredType="void**")
	public PointerPointer ppunkVal() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(tagVARIANT._ppunkValOffset_));
	}

	// void** ppunkVal
	public PointerPointer ppunkValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._ppunkValOffset_));
	}

	// I32* pscode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pscodeOffset_", declaredType="I32*")
	public IDATAPointer pscode() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(tagVARIANT._pscodeOffset_));
	}

	// I32* pscode
	public PointerPointer pscodeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pscodeOffset_));
	}

	// U16* puiVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puiValOffset_", declaredType="U16*")
	public U16Pointer puiVal() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagVARIANT._puiValOffset_));
	}

	// U16* puiVal
	public PointerPointer puiValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._puiValOffset_));
	}

	// U32* puintVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puintValOffset_", declaredType="U32*")
	public UDATAPointer puintVal() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(tagVARIANT._puintValOffset_));
	}

	// U32* puintVal
	public PointerPointer puintValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._puintValOffset_));
	}

	// U32* pulVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pulValOffset_", declaredType="U32*")
	public UDATAPointer pulVal() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(tagVARIANT._pulValOffset_));
	}

	// U32* pulVal
	public PointerPointer pulValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pulValOffset_));
	}

	// U64* pullVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pullValOffset_", declaredType="U64*")
	public UDATAPointer pullVal() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(tagVARIANT._pullValOffset_));
	}

	// U64* pullVal
	public PointerPointer pullValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pullValOffset_));
	}

	// IUnknown* punkVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_punkValOffset_", declaredType="IUnknown*")
	public IUnknownPointer punkVal() throws CorruptDataException {
		return IUnknownPointer.cast(getPointerAtOffset(tagVARIANT._punkValOffset_));
	}

	// IUnknown* punkVal
	public PointerPointer punkValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._punkValOffset_));
	}

	// void* pvRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pvRecordOffset_", declaredType="void*")
	public VoidPointer pvRecord() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tagVARIANT._pvRecordOffset_));
	}

	// void* pvRecord
	public PointerPointer pvRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pvRecordOffset_));
	}

	// tagVARIANT* pvarVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pvarValOffset_", declaredType="tagVARIANT*")
	public tagVARIANTPointer pvarVal() throws CorruptDataException {
		return tagVARIANTPointer.cast(getPointerAtOffset(tagVARIANT._pvarValOffset_));
	}

	// tagVARIANT* pvarVal
	public PointerPointer pvarValEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagVARIANT._pvarValOffset_));
	}

	// I32 scode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scodeOffset_", declaredType="I32")
	public IDATA scode() throws CorruptDataException {
		return new I32(getIntAtOffset(tagVARIANT._scodeOffset_));
	}

	// I32 scode
	public IDATAPointer scodeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagVARIANT._scodeOffset_));
	}

	// U16 uiVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uiValOffset_", declaredType="U16")
	public U16 uiVal() throws CorruptDataException {
		return new U16(getShortAtOffset(tagVARIANT._uiValOffset_));
	}

	// U16 uiVal
	public U16Pointer uiValEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagVARIANT._uiValOffset_));
	}

	// U32 uintVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uintValOffset_", declaredType="U32")
	public UDATA uintVal() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVARIANT._uintValOffset_));
	}

	// U32 uintVal
	public UDATAPointer uintValEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVARIANT._uintValOffset_));
	}

	// U32 ulVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ulValOffset_", declaredType="U32")
	public UDATA ulVal() throws CorruptDataException {
		return new U32(getIntAtOffset(tagVARIANT._ulValOffset_));
	}

	// U32 ulVal
	public UDATAPointer ulValEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVARIANT._ulValOffset_));
	}

	// U64 ullVal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullValOffset_", declaredType="U64")
	public UDATA ullVal() throws CorruptDataException {
		return new U64(getLongAtOffset(tagVARIANT._ullValOffset_));
	}

	// U64 ullVal
	public UDATAPointer ullValEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagVARIANT._ullValOffset_));
	}

	// U16 vt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vtOffset_", declaredType="U16")
	public U16 vt() throws CorruptDataException {
		return new U16(getShortAtOffset(tagVARIANT._vtOffset_));
	}

	// U16 vt
	public U16Pointer vtEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagVARIANT._vtOffset_));
	}

	// U16 wReserved1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReserved1Offset_", declaredType="U16")
	public U16 wReserved1() throws CorruptDataException {
		return new U16(getShortAtOffset(tagVARIANT._wReserved1Offset_));
	}

	// U16 wReserved1
	public U16Pointer wReserved1EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagVARIANT._wReserved1Offset_));
	}

	// U16 wReserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReserved2Offset_", declaredType="U16")
	public U16 wReserved2() throws CorruptDataException {
		return new U16(getShortAtOffset(tagVARIANT._wReserved2Offset_));
	}

	// U16 wReserved2
	public U16Pointer wReserved2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagVARIANT._wReserved2Offset_));
	}

	// U16 wReserved3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReserved3Offset_", declaredType="U16")
	public U16 wReserved3() throws CorruptDataException {
		return new U16(getShortAtOffset(tagVARIANT._wReserved3Offset_));
	}

	// U16 wReserved3
	public U16Pointer wReserved3EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagVARIANT._wReserved3Offset_));
	}

}
