/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _KDHELP64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _KDHELP64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _BuildVersionOffset_;
	public static final int _FramePointerOffset_;
	public static final int _KeUserCallbackDispatcherOffset_;
	public static final int _KiCallUserModeOffset_;
	public static final int _KiUserExceptionDispatcherOffset_;
	public static final int _NextCallbackOffset_;
	public static final int _Reserved0Offset_;
	public static final int _RetpolineStubFunctionTableOffset_;
	public static final int _RetpolineStubFunctionTableSizeOffset_;
	public static final int _RetpolineStubOffsetOffset_;
	public static final int _RetpolineStubSizeOffset_;
	public static final int _StackBaseOffset_;
	public static final int _StackLimitOffset_;
	public static final int _SystemRangeStartOffset_;
	public static final int _ThCallbackBStoreOffset_;
	public static final int _ThCallbackStackOffset_;
	public static final int _ThreadOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_BuildVersionOffset_ = 0;
		_FramePointerOffset_ = 0;
		_KeUserCallbackDispatcherOffset_ = 0;
		_KiCallUserModeOffset_ = 0;
		_KiUserExceptionDispatcherOffset_ = 0;
		_NextCallbackOffset_ = 0;
		_Reserved0Offset_ = 0;
		_RetpolineStubFunctionTableOffset_ = 0;
		_RetpolineStubFunctionTableSizeOffset_ = 0;
		_RetpolineStubOffsetOffset_ = 0;
		_RetpolineStubSizeOffset_ = 0;
		_StackBaseOffset_ = 0;
		_StackLimitOffset_ = 0;
		_SystemRangeStartOffset_ = 0;
		_ThCallbackBStoreOffset_ = 0;
		_ThCallbackStackOffset_ = 0;
		_ThreadOffset_ = 0;
	}

}
