/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _SYMBOL_INFO
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _SYMBOL_INFO {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _AddressOffset_;
	public static final int _FlagsOffset_;
	public static final int _IndexOffset_;
	public static final int _MaxNameLenOffset_;
	public static final int _ModBaseOffset_;
	public static final int _NameOffset_;
	public static final int _NameLenOffset_;
	public static final int _RegisterOffset_;
	public static final int _ReservedOffset_;
	public static final int _ScopeOffset_;
	public static final int _SizeOffset_;
	public static final int _SizeOfStructOffset_;
	public static final int _TagOffset_;
	public static final int _TypeIndexOffset_;
	public static final int _ValueOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_AddressOffset_ = 0;
		_FlagsOffset_ = 0;
		_IndexOffset_ = 0;
		_MaxNameLenOffset_ = 0;
		_ModBaseOffset_ = 0;
		_NameOffset_ = 0;
		_NameLenOffset_ = 0;
		_RegisterOffset_ = 0;
		_ReservedOffset_ = 0;
		_ScopeOffset_ = 0;
		_SizeOffset_ = 0;
		_SizeOfStructOffset_ = 0;
		_TagOffset_ = 0;
		_TypeIndexOffset_ = 0;
		_ValueOffset_ = 0;
	}

}
