/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _tagSTACKFRAME64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _tagSTACKFRAME64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _AddrBStoreOffset_;
	public static final int _AddrFrameOffset_;
	public static final int _AddrPCOffset_;
	public static final int _AddrReturnOffset_;
	public static final int _AddrStackOffset_;
	public static final int _FarOffset_;
	public static final int _FuncTableEntryOffset_;
	public static final int _KdHelpOffset_;
	public static final int _ParamsOffset_;
	public static final int _ReservedOffset_;
	public static final int _VirtualOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_AddrBStoreOffset_ = 0;
		_AddrFrameOffset_ = 0;
		_AddrPCOffset_ = 0;
		_AddrReturnOffset_ = 0;
		_AddrStackOffset_ = 0;
		_FarOffset_ = 0;
		_FuncTableEntryOffset_ = 0;
		_KdHelpOffset_ = 0;
		_ParamsOffset_ = 0;
		_ReservedOffset_ = 0;
		_VirtualOffset_ = 0;
	}

}
