/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: tagFUNCDESC
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class tagFUNCDESC {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _cParamsOffset_;
	public static final int _cParamsOptOffset_;
	public static final int _cScodesOffset_;
	public static final int _callconvOffset_;
	public static final int _elemdescFuncOffset_;
	public static final int _funckindOffset_;
	public static final int _invkindOffset_;
	public static final int _lprgelemdescParamOffset_;
	public static final int _lprgscodeOffset_;
	public static final int _memidOffset_;
	public static final int _oVftOffset_;
	public static final int _wFuncFlagsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_cParamsOffset_ = 0;
		_cParamsOptOffset_ = 0;
		_cScodesOffset_ = 0;
		_callconvOffset_ = 0;
		_elemdescFuncOffset_ = 0;
		_funckindOffset_ = 0;
		_invkindOffset_ = 0;
		_lprgelemdescParamOffset_ = 0;
		_lprgscodeOffset_ = 0;
		_memidOffset_ = 0;
		_oVftOffset_ = 0;
		_wFuncFlagsOffset_ = 0;
	}

}
